/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.ehrbase.openehr.sdk.aql.dto.LogicalOperator;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.DisjunctablePredicate;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.Predicate;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.PredicateLogicalOperatorSymbol;

public final class PredicateLogicalOrOperation
implements Predicate,
LogicalOperator<PredicateLogicalOperatorSymbol, DisjunctablePredicate>,
Serializable {
    private final PredicateLogicalOperatorSymbol symbol = PredicateLogicalOperatorSymbol.OR;
    private List<DisjunctablePredicate> values;

    public PredicateLogicalOrOperation(DisjunctablePredicate ... values) {
        this.values = List.of(values);
    }

    PredicateLogicalOrOperation() {
        this.values = List.of();
    }

    @Override
    public PredicateLogicalOperatorSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public List<DisjunctablePredicate> getValues() {
        return this.values;
    }

    public PredicateLogicalOrOperation addValues(Stream<DisjunctablePredicate> valuesStream) {
        DisjunctablePredicate[] newValues = (DisjunctablePredicate[])Stream.concat(this.values.stream(), valuesStream).toArray(DisjunctablePredicate[]::new);
        return new PredicateLogicalOrOperation(newValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateLogicalOrOperation that = (PredicateLogicalOrOperation)o;
        return this.symbol == that.symbol && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.values});
    }

    public String toString() {
        return "PredicateLogicalOrOperation{symbol=" + String.valueOf((Object)this.symbol) + ", values=" + String.valueOf(this.values) + "}";
    }
}

