/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.parser;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryVisitor;
import org.ehrbase.openehr.sdk.aql.parser.antlr.AqlLexer;
import org.ehrbase.openehr.sdk.aql.parser.antlr.AqlParser;
import org.ehrbase.openehr.sdk.util.exception.SDKErrorListener;

public final class AqlQueryParser {
    private AqlQueryParser() {
    }

    public static AqlQuery parse(String aql) {
        return AqlQueryParser.parseQueryComponent(aql, AqlParser::selectQuery, AqlQueryVisitor::visitSelectQuery);
    }

    private static <T> T parseQueryComponent(String source, BiFunction<AqlParser, AqlQueryVisitor, T> extractor) {
        T component;
        AqlLexer aqlLexer = new AqlLexer((CharStream)CharStreams.fromString((String)source));
        aqlLexer.removeErrorListeners();
        aqlLexer.addErrorListener((ANTLRErrorListener)SDKErrorListener.INSTANCE);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)aqlLexer);
        AqlParser aqlParser = new AqlParser((TokenStream)commonTokenStream);
        aqlParser.removeErrorListeners();
        aqlParser.addErrorListener((ANTLRErrorListener)SDKErrorListener.INSTANCE);
        AqlQueryVisitor listener = new AqlQueryVisitor();
        try {
            component = extractor.apply(aqlParser, listener);
        }
        catch (ParseCancellationException e) {
            throw new AqlParseException(e.getMessage(), e);
        }
        if (!listener.getErrors().isEmpty()) {
            throw new AqlParseException(String.format("Cannot parse %s: %s", source, String.join((CharSequence)",", listener.getErrors())));
        }
        return component;
    }

    public static <T, U> U parseQueryComponent(String source, Function<AqlParser, T> parserFunc, BiFunction<AqlQueryVisitor, T, U> visitorFunc) {
        return (U)AqlQueryParser.parseQueryComponent(source, (p, l) -> visitorFunc.apply((AqlQueryVisitor)l, (Object)parserFunc.apply((AqlParser)((Object)p))));
    }

    public static AqlObjectPath parsePath(String aqlPath) {
        if (StringUtils.isEmpty((CharSequence)aqlPath)) {
            return null;
        }
        return AqlQueryParser.parseQueryComponent(aqlPath, AqlParser::objectPath, AqlQueryVisitor::visitObjectPath);
    }

    public static List<AndOperatorPredicate> parsePredicate(String aqlPathPredicate) {
        return AqlQueryParser.parseQueryComponent(aqlPathPredicate, AqlParser::pathPredicate, AqlQueryVisitor::visitPathPredicate);
    }
}

