/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.dto.LogicalOperator;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.operand.DoublePrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.LongPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPathHelper;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.DisjunctablePredicate;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.Predicate;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.PredicateComparisonOperator;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.PredicateLogicalAndOperation;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.PredicateLogicalOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.predicate.PredicateLogicalOrOperation;
import org.ehrbase.openehr.sdk.util.CharSequenceHelper;
import org.ehrbase.openehr.sdk.util.exception.SdkException;

public class PredicateHelper {
    public static final String NAME_VALUE = "name/value";
    public static final String ARCHETYPE_NODE_ID = "archetype_node_id";
    private static final AqlPathHelper.PrefixMatcher OPERATOR_SYMBOLS = AqlPathHelper.PrefixMatcher.forStrings((String[])Arrays.stream(ComparisonOperatorSymbol.values()).map(ComparisonOperatorSymbol::getSymbol).toArray(String[]::new));
    private static final PredicateComparisonOperator NO_PREDICATE = new PredicateComparisonOperator(null, null, null);
    private static final AqlPathHelper.PrefixMatcher PREDICATES_MATCHER = AqlPathHelper.PrefixMatcher.forStrings(" and ", " AND ", " or ", " OR ", ",");
    static final Comparator<Predicate> PREDICATE_DTO_COMPARATOR = Comparator.comparingInt(PredicateHelper::comparisonKey);

    private static int comparisonKey(Predicate dto) {
        if (dto instanceof PredicateComparisonOperator) {
            switch (((PredicateComparisonOperator)dto).getStatement()) {
                case "archetype_node_id": {
                    return 1;
                }
                case "name/value": {
                    return 2;
                }
            }
            return 3;
        }
        return 9;
    }

    private PredicateHelper() {
    }

    public static Predicate buildPredicate(CharSequence predicate) {
        Object[] boolList = PredicateHelper.parsePredicate(predicate);
        if (boolList.length == 1) {
            return (Predicate)boolList[0];
        }
        LogicalOperator predicateLogicalOperator = PredicateHelper.buildLogicalOperator(Arrays.asList(boolList), s -> {
            LogicalOperator<PredicateLogicalOperatorSymbol, PredicateComparisonOperator> ret = PredicateLogicalOperatorSymbol.AND.equals(s) ? new PredicateLogicalAndOperation() : new PredicateLogicalOrOperation();
            return ret;
        }, PredicateLogicalOperatorSymbol::getPrecedence);
        return (Predicate)((Object)predicateLogicalOperator);
    }

    static Object[] parsePredicate(CharSequence predicate) {
        List<CharSequence> split = AqlPathHelper.split(predicate, 0, -1, true, PREDICATES_MATCHER);
        Object[] ret = new Object[split.size()];
        int l = split.size();
        for (int i = 0; i < l; ++i) {
            ret[i] = i % 2 == 0 ? PredicateHelper.handleOperator(split.get(i), i) : PredicateHelper.handleSymbol(split.get(i));
        }
        return ret;
    }

    private static PredicateLogicalOperatorSymbol handleSymbol(CharSequence sequence) {
        switch (CharSequenceHelper.trim((CharSequence)sequence).toString()) {
            case ",": 
            case "and": 
            case "AND": {
                return PredicateLogicalOperatorSymbol.AND;
            }
            case "or": 
            case "OR": {
                return PredicateLogicalOperatorSymbol.OR;
            }
        }
        throw new SdkException(String.format("Unknown symbol %s", sequence));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PredicateComparisonOperator handleOperator(CharSequence sequence, int i) {
        PathPredicateOperand value;
        ComparisonOperatorSymbol operator;
        String statement;
        List<CharSequence> split = AqlPathHelper.split(sequence, 0, 3, true, OPERATOR_SYMBOLS);
        if (split.size() == 1) {
            if (i == 0) {
                statement = ARCHETYPE_NODE_ID;
                operator = ComparisonOperatorSymbol.EQ;
                value = PredicateHelper.parseValue(ARCHETYPE_NODE_ID, CharSequenceHelper.trim((CharSequence)split.get(0)));
                return new PredicateComparisonOperator(statement, operator, value);
            } else {
                if (i != 2) throw new IllegalArgumentException();
                statement = NAME_VALUE;
                operator = ComparisonOperatorSymbol.EQ;
                value = PredicateHelper.parseValue(NAME_VALUE, CharSequenceHelper.trim((CharSequence)split.get(0)));
            }
            return new PredicateComparisonOperator(statement, operator, value);
        } else {
            statement = CharSequenceHelper.trim((CharSequence)split.get(0)).toString();
            operator = ComparisonOperatorSymbol.fromSymbol(split.get(1));
            value = PredicateHelper.parseValue(statement, CharSequenceHelper.trim((CharSequence)split.get(2)));
        }
        return new PredicateComparisonOperator(statement, operator, value);
    }

    private static PathPredicateOperand parseValue(String statement, CharSequence s) {
        if (s.length() > 0 && s.charAt(0) == '$') {
            QueryParameter parameterValue = new QueryParameter();
            parameterValue.setName(CharSequenceHelper.subSequence((CharSequence)s, (int)1).toString());
            return parameterValue;
        }
        if (ARCHETYPE_NODE_ID.equals(statement)) {
            return new StringPrimitive(s.toString());
        }
        if (s.length() > 1 && s.charAt(0) == '\'') {
            return new StringPrimitive(CharSequenceHelper.subSequence((CharSequence)s, (int)1, (int)(s.length() - 1)).toString());
        }
        if (PredicateHelper.representsPlainInteger(s)) {
            return new LongPrimitive(Long.parseLong(s.toString()));
        }
        return new DoublePrimitive(Double.parseDouble(s.toString()));
    }

    static boolean representsPlainInteger(CharSequence s) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (!Character.isDigit(c) && (i != 0 || c != '-')) continue;
            return false;
        }
        return true;
    }

    private static void format(String statement, StringBuilder sb, PathPredicateOperand value) {
        if (value instanceof Primitive) {
            Object o = ((Primitive)value).getValue();
            if (o instanceof String && !ARCHETYPE_NODE_ID.equals(statement)) {
                sb.append(StringUtils.wrap((String)o.toString(), (String)"'"));
            } else {
                sb.append(o);
            }
        } else if (value instanceof QueryParameter) {
            sb.append('$').append(((QueryParameter)value).getName());
        }
    }

    public static String format(Predicate predicate, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        StringBuilder sb = new StringBuilder();
        PredicateHelper.format(sb, predicate, otherPredicatesFormat);
        return sb.toString();
    }

    public static void format(StringBuilder sb, Predicate predicate, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (predicate instanceof PredicateComparisonOperator) {
            PredicateHelper.formatPredicateComparisonOperatorDto(sb, (PredicateComparisonOperator)predicate, otherPredicatesFormat);
        } else if (predicate instanceof PredicateLogicalAndOperation) {
            PredicateHelper.formatPredicateLogicalAndOperation(sb, (PredicateLogicalAndOperation)predicate, otherPredicatesFormat);
        } else if (predicate instanceof PredicateLogicalOrOperation) {
            PredicateHelper.formatPredicateLogicalOrOperation(sb, (PredicateLogicalOrOperation)predicate, otherPredicatesFormat);
        } else {
            throw new IllegalArgumentException("Unexpected predicate type: " + predicate.getClass().getName());
        }
    }

    private static void formatPredicateLogicalOrOperation(StringBuilder sb, PredicateLogicalOrOperation predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (otherPredicatesFormat.equals((Object)AqlPath.OtherPredicatesFormat.SHORTED)) {
            otherPredicatesFormat = AqlPath.OtherPredicatesFormat.FULL;
        }
        List<DisjunctablePredicate> values = predicateDto.getValues();
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0 && !PredicateHelper.isNone(values.get(i), otherPredicatesFormat)) {
                sb.append(" or ");
            }
            PredicateHelper.format(sb, values.get(i), otherPredicatesFormat);
        }
    }

    private static void formatPredicateLogicalAndOperation(StringBuilder sb, PredicateLogicalAndOperation predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        DisjunctablePredicate[] values = (DisjunctablePredicate[])predicateDto.getValues().toArray(DisjunctablePredicate[]::new);
        Arrays.sort(values, PREDICATE_DTO_COMPARATOR);
        for (int i = 0; i < values.length; ++i) {
            DisjunctablePredicate value = values[i];
            if (PredicateHelper.isNone(value, otherPredicatesFormat)) continue;
            if (i > 0) {
                if (PredicateHelper.isShorten(value, otherPredicatesFormat)) {
                    sb.append(",");
                } else {
                    sb.append(" and ");
                }
            }
            PredicateHelper.format(sb, value, otherPredicatesFormat);
        }
    }

    private static void formatPredicateComparisonOperatorDto(StringBuilder sb, PredicateComparisonOperator predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (PredicateHelper.isShorten(predicateDto, otherPredicatesFormat)) {
            PredicateHelper.format(predicateDto.getStatement(), sb, predicateDto.getValue());
        } else if (!PredicateHelper.isNone(predicateDto, otherPredicatesFormat)) {
            sb.append(predicateDto.getStatement()).append(predicateDto.getSymbol().getSymbol());
            PredicateHelper.format(predicateDto.getStatement(), sb, predicateDto.getValue());
        }
    }

    private static boolean isNone(DisjunctablePredicate predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        return AqlPath.OtherPredicatesFormat.NONE == otherPredicatesFormat && predicateDto instanceof PredicateComparisonOperator && !ARCHETYPE_NODE_ID.equals(((PredicateComparisonOperator)predicateDto).getStatement());
    }

    private static boolean isShorten(DisjunctablePredicate predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        PredicateComparisonOperator cmpOpDto;
        if (predicateDto instanceof PredicateComparisonOperator && (cmpOpDto = (PredicateComparisonOperator)predicateDto).getStatement().equals(ARCHETYPE_NODE_ID)) {
            return true;
        }
        if (otherPredicatesFormat == AqlPath.OtherPredicatesFormat.FULL) {
            return false;
        }
        if (predicateDto instanceof PredicateComparisonOperator) {
            cmpOpDto = (PredicateComparisonOperator)predicateDto;
            return ComparisonOperatorSymbol.EQ == cmpOpDto.getSymbol() && List.of(NAME_VALUE, ARCHETYPE_NODE_ID).contains(cmpOpDto.getStatement());
        }
        if (predicateDto instanceof PredicateLogicalAndOperation) {
            List<PredicateComparisonOperator> andOpVals = ((PredicateLogicalAndOperation)predicateDto).getValues();
            return CollectionUtils.isNotEmpty(andOpVals) && PredicateHelper.isShorten(andOpVals.get(andOpVals.size() - 1), otherPredicatesFormat);
        }
        throw new IllegalArgumentException("Unexpected predicate type: " + predicateDto.getClass().getName());
    }

    public static Optional<PredicateComparisonOperator> find(Predicate predicate, String statement) {
        List values;
        if (predicate instanceof PredicateComparisonOperator) {
            PredicateComparisonOperator cmpOp = (PredicateComparisonOperator)predicate;
            return Optional.of(cmpOp).filter(op -> statement.equals(op.getStatement()));
        }
        if (predicate instanceof PredicateLogicalOrOperation) {
            PredicateLogicalOrOperation orOp = (PredicateLogicalOrOperation)predicate;
            values = orOp.getValues();
        } else if (predicate instanceof PredicateLogicalAndOperation) {
            PredicateLogicalAndOperation andOp = (PredicateLogicalAndOperation)predicate;
            values = andOp.getValues();
        } else {
            return Optional.empty();
        }
        if (values.isEmpty()) {
            return Optional.empty();
        }
        for (Predicate v : values) {
            PredicateComparisonOperator cmpOp;
            if (!(v instanceof PredicateComparisonOperator) || !statement.equals((cmpOp = (PredicateComparisonOperator)v).getStatement())) continue;
            return Optional.of(cmpOp);
        }
        List currentList = values;
        LinkedList<List<PredicateComparisonOperator>> remainingLists = new LinkedList<List<PredicateComparisonOperator>>();
        do {
            for (Predicate pred : currentList) {
                List<PredicateComparisonOperator> values2;
                if (pred instanceof PredicateLogicalOrOperation) {
                    PredicateLogicalOrOperation orOp = (PredicateLogicalOrOperation)pred;
                    List<DisjunctablePredicate> values22 = orOp.getValues();
                } else {
                    if (!(pred instanceof PredicateLogicalAndOperation)) continue;
                    PredicateLogicalAndOperation andOp = (PredicateLogicalAndOperation)pred;
                    values2 = andOp.getValues();
                }
                for (Predicate predicate2 : values2) {
                    PredicateComparisonOperator cmpOp;
                    if (!(predicate2 instanceof PredicateComparisonOperator) || !statement.equals((cmpOp = (PredicateComparisonOperator)predicate2).getStatement())) continue;
                    return Optional.of(cmpOp);
                }
                if (values2.isEmpty()) continue;
                remainingLists.add(values2);
            }
        } while ((currentList = (List)remainingLists.pollFirst()) != null);
        return Optional.empty();
    }

    public static PredicateLogicalAndOperation remove(PredicateLogicalAndOperation and, ComparisonOperatorSymbol symbol, String ... remove) {
        return PredicateHelper.removeInternal(and, cmpOp -> (symbol == null || symbol == cmpOp.getSymbol()) && ArrayUtils.contains((Object[])remove, (Object)cmpOp.getStatement()));
    }

    private static <P extends DisjunctablePredicate> P removeInternal(P predicate, java.util.function.Predicate<PredicateComparisonOperator> filter) {
        if (predicate instanceof PredicateComparisonOperator) {
            PredicateComparisonOperator cmpOp = (PredicateComparisonOperator)predicate;
            if (filter.test(cmpOp)) {
                return (P)NO_PREDICATE;
            }
            return predicate;
        }
        if (predicate instanceof PredicateLogicalAndOperation) {
            ArrayList<PredicateComparisonOperator> newValues = null;
            List<PredicateComparisonOperator> values = ((PredicateLogicalAndOperation)predicate).getValues();
            int newPos = 0;
            int s = values.size();
            for (int i = 0; i < s; ++i) {
                boolean removeNode;
                PredicateComparisonOperator child = values.get(i);
                PredicateComparisonOperator newChild = PredicateHelper.removeInternal(child, filter);
                if (newChild == child) continue;
                boolean bl = removeNode = newChild == NO_PREDICATE;
                if (newValues == null) {
                    newValues = new ArrayList<PredicateComparisonOperator>(removeNode ? s - 1 : s);
                }
                if (i > newPos) {
                    newValues.addAll(values.subList(newPos, i));
                }
                if (!removeNode) {
                    newValues.add(newChild);
                }
                newPos = i + 1;
            }
            if (newPos == 0) {
                return predicate;
            }
            if (newPos < s) {
                newValues.addAll(values.subList(newPos, s));
            }
            return (P)new PredicateLogicalAndOperation((PredicateComparisonOperator[])newValues.toArray(PredicateComparisonOperator[]::new));
        }
        return predicate;
    }

    private static <S, T> LogicalOperator<S, T> buildLogicalOperator(List<Object> boolList, Function<S, LogicalOperator<S, T>> creator, ToIntFunction<S> precedenceFunction) {
        OperatorStructure<S> structure = PredicateHelper.buildLogicalOperatorStructure(boolList, precedenceFunction);
        return PredicateHelper.buildLogicalOperator(structure, creator);
    }

    private static <S, T> LogicalOperator<S, T> buildLogicalOperator(OperatorStructure<S> structure, Function<S, LogicalOperator<S, T>> creator) {
        LogicalOperator<S, Object> operator = creator.apply(structure.getSymbol());
        Stream<Object> stream = structure.getChildren().stream().map(v -> {
            if (v instanceof OperatorStructure) {
                return PredicateHelper.buildLogicalOperator((OperatorStructure)v, creator);
            }
            return v;
        });
        return operator.addValues(stream);
    }

    private static <S> OperatorStructure<S> buildLogicalOperatorStructure(List<Object> boolList, ToIntFunction<S> precedenceFunction) {
        OperatorStructure<Object> currentOperator;
        Object currentSymbol = boolList.get(1);
        OperatorStructure<Object> lowestOperator = currentOperator = new OperatorStructure<Object>(currentSymbol, boolList.get(0));
        int l = boolList.size();
        for (int i = 2; i < l; i += 2) {
            Object nextSymbol = i + 1 < l ? boolList.get(i + 1) : null;
            Object currentOpValue = boolList.get(i);
            if (nextSymbol == null || Objects.equals(currentSymbol, nextSymbol)) {
                currentOperator.addChild(currentOpValue);
            } else {
                OperatorStructure<Object> nextOperator = new OperatorStructure<Object>(nextSymbol, new Object[0]);
                if (PredicateHelper.hasHigherPrecedence(currentSymbol, nextSymbol, precedenceFunction)) {
                    currentOperator.addChild(currentOpValue);
                    nextOperator.addChild(currentOperator);
                    lowestOperator = nextOperator;
                } else {
                    nextOperator.addChild(currentOpValue);
                    currentOperator.addChild(nextOperator);
                    lowestOperator = currentOperator;
                }
                currentOperator = nextOperator;
            }
            currentSymbol = nextSymbol;
        }
        return lowestOperator;
    }

    private static <S> boolean hasHigherPrecedence(S operatorSymbol, S nextOperatorSymbol, ToIntFunction<S> precedenceFunction) {
        if (nextOperatorSymbol == null) {
            return true;
        }
        return precedenceFunction.applyAsInt(operatorSymbol) <= precedenceFunction.applyAsInt(nextOperatorSymbol);
    }

    private static final class OperatorStructure<S> {
        private final S symbol;
        private final List<Object> children;

        private OperatorStructure(S symbol, Object ... children) {
            this.symbol = symbol;
            this.children = Arrays.stream(children).collect(Collectors.toList());
        }

        public S getSymbol() {
            return this.symbol;
        }

        public List<Object> getChildren() {
            return this.children;
        }

        public void addChild(Object child) {
            this.children.add(child);
        }
    }
}

