/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.dto.containment;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.serializer.PredicateDeserializer;
import org.ehrbase.openehr.sdk.aql.serializer.PredicateSerializer;

@JsonPropertyOrder(value={"type", "predicates", "contains"})
public final class ContainmentClassExpression
extends AbstractContainmentExpression {
    private String type;
    protected List<AndOperatorPredicate> predicates;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    @JsonSerialize(using=PredicateSerializer.class)
    public List<AndOperatorPredicate> getPredicates() {
        return this.predicates;
    }

    @JsonDeserialize(using=PredicateDeserializer.class)
    public void setPredicates(List<AndOperatorPredicate> predicates) {
        this.predicates = predicates != null ? new ArrayList<AndOperatorPredicate>(predicates) : null;
    }

    @Override
    public boolean hasPredicates() {
        return CollectionUtils.isNotEmpty(this.predicates);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainmentClassExpression that = (ContainmentClassExpression)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.predicates, that.predicates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.predicates);
    }

    @Override
    public String toString() {
        return "ContainmentClassExpression{type='%s', predicates=%s, %s}".formatted(this.type, this.predicates, super.toString());
    }
}

