/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.dto.path;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.util.Freezable;

public class AqlObjectPath
implements PathPredicateOperand<AqlObjectPath> {
    private final List<PathNode> pathNodes;
    private boolean frozen = false;

    private AqlObjectPath(List<PathNode> pathNodes, boolean frozen) {
        this.frozen = frozen;
        this.pathNodes = pathNodes;
    }

    public AqlObjectPath(List<PathNode> pathNodes) {
        this(Freezable.clone(pathNodes), false);
    }

    public AqlObjectPath(PathNode ... pathNodes) {
        this(Arrays.asList(pathNodes));
    }

    public List<PathNode> getPathNodes() {
        return this.pathNodes;
    }

    public static AqlObjectPath parse(String path) {
        return AqlQueryParser.parsePath(path);
    }

    public String render() {
        return AqlRenderer.render(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AqlObjectPath that = (AqlObjectPath)o;
        return new EqualsBuilder().append(this.pathNodes, that.pathNodes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.pathNodes).toHashCode();
    }

    public String toString() {
        return "ObjectPath{pathParts=" + this.pathNodes + "}";
    }

    public static AqlObjectPathBuilder builder() {
        return new AqlObjectPathBuilder();
    }

    public AqlObjectPath thawed() {
        return new AqlObjectPath(Freezable.thawed(this.pathNodes), false);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public AqlObjectPath frozen() {
        return (AqlObjectPath)Freezable.frozen((Freezable)this, o -> new AqlObjectPath(Freezable.frozen(o.getPathNodes()), true));
    }

    public AqlObjectPath clone() {
        return (AqlObjectPath)Freezable.clone((Freezable)this, o -> new AqlObjectPath(o.getPathNodes()));
    }

    public static AqlObjectPath fromAqlPath(AqlPath aqlPath) {
        return Optional.of(aqlPath).filter(AqlPath::hasPath).map(p -> p.format(true)).map(s -> StringUtils.removeStart((String)s, (String)"/")).map(AqlObjectPath::parse).orElse(null);
    }

    public static AqlPath toAqlPath(AqlObjectPath aqlObjectPath) {
        return Optional.ofNullable(aqlObjectPath).map(AqlObjectPath::render).map(AqlPath::parse).orElse(AqlPath.EMPTY_PATH);
    }

    public boolean endsWith(AqlObjectPath path) {
        List<PathNode> myNodes = this.getPathNodes();
        List otherNodes = Optional.ofNullable(path).map(AqlObjectPath::getPathNodes).orElse(List.of());
        int mySize = myNodes.size();
        int start = mySize - otherNodes.size();
        if (start < 0) {
            return false;
        }
        return otherNodes.equals(myNodes.subList(start, mySize));
    }

    public static final class AqlObjectPathBuilder {
        private final Stream.Builder<PathNode> nodes = Stream.builder();

        private AqlObjectPathBuilder() {
        }

        public AqlObjectPath build() {
            return new AqlObjectPath(this.nodes.build().toList());
        }

        public AqlObjectPathBuilder nodes(AqlObjectPath path) {
            path.getPathNodes().stream().map(PathNode::clone).forEach(this.nodes::add);
            return this;
        }

        public AqlObjectPathBuilder node(String attribute) {
            this.nodes.add(new PathNode(attribute));
            return this;
        }

        public AqlObjectPathBuilder node(String attribute, List<AndOperatorPredicate> predicates) {
            this.nodes.add(new PathNode(attribute, predicates));
            return this;
        }

        public AqlObjectPathBuilder node(String attribute, ComparisonOperatorPredicate ... predicates) {
            this.nodes.add(new PathNode(attribute, List.of(new AndOperatorPredicate(Arrays.asList(predicates)))));
            return this;
        }
    }

    public static class PathNode
    implements Freezable<PathNode> {
        private final String attribute;
        private final List<AndOperatorPredicate> predicateOrOperands;
        private boolean frozen = false;

        private PathNode(String attribute, List<AndOperatorPredicate> predicateOrOperands, boolean frozen) {
            if (StringUtils.isBlank((CharSequence)attribute)) {
                throw new IllegalArgumentException("attribute must not be blank/empty/null");
            }
            this.frozen = frozen;
            this.attribute = attribute;
            this.predicateOrOperands = predicateOrOperands;
        }

        public PathNode(String attribute) {
            this(attribute, List.of());
        }

        public PathNode(String attribute, List<AndOperatorPredicate> predicateOrOperands) {
            this(attribute, Freezable.clone(predicateOrOperands), false);
        }

        public String getAttribute() {
            return this.attribute;
        }

        public List<AndOperatorPredicate> getPredicateOrOperands() {
            return this.predicateOrOperands;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathNode pathNode = (PathNode)o;
            return new EqualsBuilder().append((Object)this.attribute, (Object)pathNode.attribute).append(this.predicateOrOperands, pathNode.predicateOrOperands).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.attribute).append(this.predicateOrOperands).toHashCode();
        }

        public String toString() {
            return "PathPart{attribute='" + this.attribute + "', predicate=" + this.predicateOrOperands + "}";
        }

        public PathNode thawed() {
            return new PathNode(this.getAttribute(), Freezable.thawed(this.getPredicateOrOperands()), false);
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public PathNode frozen() {
            return (PathNode)Freezable.frozen((Freezable)this, t -> new PathNode(t.attribute, Freezable.frozen(t.predicateOrOperands), true));
        }

        public PathNode clone() {
            return (PathNode)Freezable.clone((Freezable)this, t -> new PathNode(t.attribute, t.predicateOrOperands));
        }
    }
}

