/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.building.webtemplateskeletnbuilder;

import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.FlatPath;

public class WebTemplateSkeletonBuilder {
    private static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private static final RMObjectCreator RM_OBJECT_CREATOR = new RMObjectCreator((ModelInfoLookup)ARCHIE_RM_INFO_LOOKUP);

    private WebTemplateSkeletonBuilder() {
    }

    public static Composition build(WebTemplate template, boolean withChildren) {
        Composition composition = WebTemplateSkeletonBuilder.build(template.getTree(), withChildren, Composition.class);
        composition.setArchetypeDetails(new Archetyped());
        composition.getArchetypeDetails().setTemplateId(new TemplateId());
        composition.getArchetypeDetails().getTemplateId().setValue(template.getTemplateId());
        composition.getArchetypeDetails().setRmVersion("1.0.4");
        composition.getArchetypeDetails().setArchetypeId(new ArchetypeID(composition.getArchetypeNodeId()));
        return composition;
    }

    public static <T> T build(WebTemplateNode node, boolean withChildren, Class<T> clazz) {
        Object skeleton;
        String rmclass = node.getRmType();
        CComplexObject elementConstraint = new CComplexObject();
        elementConstraint.setRmTypeName(rmclass);
        switch (rmclass) {
            case "UID_BASED_ID": {
                skeleton = new HierObjectId();
                break;
            }
            case "PARTY_PROXY": {
                skeleton = new PartyIdentified();
                break;
            }
            case "STRING": 
            case "LONG": {
                skeleton = null;
                break;
            }
            case "BOOLEAN": {
                skeleton = false;
                break;
            }
            default: {
                skeleton = RM_OBJECT_CREATOR.create((CObject)elementConstraint);
            }
        }
        if (withChildren) {
            node.getChildren().stream().filter(n -> !List.of("name", "archetype_node_id", "offset").contains(n.getId())).forEach(c -> {
                Object childObject = WebTemplateSkeletonBuilder.build(c, true, Object.class);
                WebTemplateSkeletonBuilder.insert(node, (RMObject)skeleton, c, childObject);
            });
        }
        if (skeleton instanceof Locatable) {
            Optional name = node.findChildById("name");
            if (name.isPresent()) {
                if (((WebTemplateNode)name.get()).getRmType().equals("DV_CODED_TEXT")) {
                    ((Locatable)skeleton).setName((DvText)WebTemplateSkeletonBuilder.extractDefault((WebTemplateNode)name.get(), DvCodedText.class).orElseThrow());
                } else {
                    ((Locatable)skeleton).setName(WebTemplateSkeletonBuilder.extractDefault((WebTemplateNode)name.get(), DvText.class).orElse(new DvText(node.getName())));
                }
            } else {
                ((Locatable)skeleton).setName(new DvText(node.getName()));
            }
            ((Locatable)skeleton).setArchetypeNodeId(node.getNodeId());
        }
        if (skeleton instanceof Entry) {
            ((Entry)skeleton).setEncoding(new CodePhrase(new TerminologyId("IANA_character-sets"), "UTF-8"));
            node.findChildById("subject").map(n -> WebTemplateSkeletonBuilder.build(n, false, PartyProxy.class)).ifPresent(arg_0 -> ((Entry)((Entry)skeleton)).setSubject(arg_0));
        }
        if (skeleton instanceof Composition) {
            node.findChildById("category").flatMap(n -> WebTemplateSkeletonBuilder.extractDefault(n, DvCodedText.class)).ifPresent(arg_0 -> ((Composition)((Composition)skeleton)).setCategory(arg_0));
        }
        if (skeleton instanceof DvInterval) {
            ((DvInterval)skeleton).setLowerIncluded(true);
            ((DvInterval)skeleton).setUpperIncluded(true);
        }
        if (skeleton instanceof PartyRelated) {
            node.findChildById("relationship").flatMap(n -> WebTemplateSkeletonBuilder.extractDefault(n, DvCodedText.class)).ifPresent(arg_0 -> ((PartyRelated)((PartyRelated)skeleton)).setRelationship(arg_0));
        }
        if (skeleton == null || clazz.isAssignableFrom(skeleton.getClass())) {
            return (T)skeleton;
        }
        throw new SdkException(String.format("%s not assignable from %s", skeleton.getClass(), clazz));
    }

    public static void insert(WebTemplateNode parentNode, RMObject parentObject, WebTemplateNode childNode, Object childObject) {
        String attributeName = FlatPath.removeStart((FlatPath)new FlatPath(childNode.getAqlPath(true)), (FlatPath)new FlatPath(parentNode.getAqlPath(true))).getLast().getName();
        RM_OBJECT_CREATOR.addElementToListOrSetSingleValues((Object)parentObject, attributeName, Collections.singletonList(childObject));
    }

    public static void remove(WebTemplateNode parentNode, RMObject parentObject, WebTemplateNode childNode, Object removeChildObject) {
        String attributeName = FlatPath.removeStart((FlatPath)new FlatPath(childNode.getAqlPath(true)), (FlatPath)new FlatPath(parentNode.getAqlPath(true))).getLast().getName();
        RMAttributeInfo attributeInfo = ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parentObject.getClass(), attributeName);
        try {
            Object actualChild = attributeInfo.getGetMethod().invoke((Object)parentObject, new Object[0]);
            if (actualChild instanceof Collection) {
                ((Collection)actualChild).remove(removeChildObject);
            } else if (Objects.equals(actualChild, removeChildObject)) {
                attributeInfo.getSetMethod().invoke((Object)parentObject, new Object[]{null});
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SdkException(e.getMessage());
        }
    }

    public static <T> Optional<T> extractDefault(WebTemplateNode node, Class<T> clazz) {
        String rmclass = node.getRmType();
        DvCodedText defaultValue = null;
        switch (rmclass) {
            case "DV_CODED_TEXT": {
                Optional<WebTemplateInput> code;
                if (node.getMin() <= 0 || !(code = node.getInputs().stream().filter(i -> i.getSuffix().equals("code")).filter(i -> i.getList().size() == 1).findAny()).isPresent()) break;
                defaultValue = new DvCodedText(((WebTemplateInputValue)code.get().getList().get(0)).getLabel(), new CodePhrase(new TerminologyId(code.get().getTerminology()), ((WebTemplateInputValue)code.get().getList().get(0)).getValue()));
                break;
            }
            default: {
                defaultValue = null;
            }
        }
        return Optional.ofNullable(defaultValue);
    }
}

