/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.normalizer;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.generic.PartySelf;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class Normalizer {
    public <T> T normalize(T t) {
        return this.normalize(t, true);
    }

    private <T> T normalize(T t, boolean root) {
        if (t == null) {
            return null;
        }
        if (DvInterval.class.isAssignableFrom(t.getClass())) {
            ((DvInterval)t).setLower(this.normalize(((DvInterval)t).getLower(), false));
            ((DvInterval)t).setUpper(this.normalize(((DvInterval)t).getUpper(), false));
            return t.equals(new DvInterval()) ? null : (T)t;
        }
        List allFields = Arrays.stream(FieldUtils.getAllFields(t.getClass())).collect(Collectors.toList());
        boolean empty = allFields.stream().map(f -> this.normalizeField((Field)f, t)).reduce(!allFields.isEmpty(), (b1, b2) -> b1 != false && b2 != false);
        if (PartySelf.class.isAssignableFrom(t.getClass())) {
            return t;
        }
        if (empty && !root) {
            return null;
        }
        return t;
    }

    private boolean normalizeField(Field field, Object object) {
        try {
            Object normalize;
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), object.getClass());
            Object value = propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
            if (value == null) {
                normalize = null;
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection collection = (Collection)value;
                ArrayList newColl = new ArrayList();
                for (Object subValue : collection) {
                    Object subNormal = this.normalize(subValue, false);
                    if (subNormal == null) continue;
                    newColl.add(subValue);
                }
                collection.clear();
                collection.addAll(newColl);
                normalize = value;
            } else {
                normalize = RMObject.class.isAssignableFrom(value.getClass()) ? this.normalize(value, false) : value;
            }
            propertyDescriptor.getWriteMethod().invoke(object, normalize);
            return this.checkIsEmpty(field, normalize);
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            return true;
        }
    }

    private boolean checkIsEmpty(Field field, Object normalize) {
        if (field.getDeclaringClass().equals(Locatable.class) || field.getDeclaringClass().equals(Entry.class)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            return CollectionUtils.isEmpty((Collection)((Collection)normalize));
        }
        return normalize == null;
    }
}

