/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.changecontrol.Contribution;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.exception.OptimisticLockException;
import org.ehrbase.client.exception.WrongStatusCodeException;
import org.ehrbase.client.flattener.DefaultValuesProvider;
import org.ehrbase.client.openehrclient.AdminEhrEndpoint;
import org.ehrbase.client.openehrclient.AdminTemplateEndpoint;
import org.ehrbase.client.openehrclient.AqlEndpoint;
import org.ehrbase.client.openehrclient.CompositionEndpoint;
import org.ehrbase.client.openehrclient.FolderDAO;
import org.ehrbase.client.openehrclient.OpenEhrClient;
import org.ehrbase.client.openehrclient.OpenEhrClientConfig;
import org.ehrbase.client.openehrclient.TemplateEndpoint;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.client.openehrclient.VersionedCompositionEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestAdminEhrEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestAdminTemplateEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestAqlEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestCompositionEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestDirectoryEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestEhrEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestTemplateEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestVersionedCompositionEndpoint;
import org.ehrbase.client.templateprovider.ClientTemplateProvider;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.serialisation.mapper.RmObjectJsonDeSerializer;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;

public class DefaultRestClient
implements OpenEhrClient {
    static final ObjectMapper OBJECT_MAPPER = DefaultRestClient.createObjectMapper();
    private final OpenEhrClientConfig config;
    private final TemplateProvider templateProvider;
    private final Executor executor;
    private final DefaultRestEhrEndpoint defaultRestEhrEndpoint;
    private final Map<UUID, DefaultRestDirectoryEndpoint> directoryEndpointMap = new WeakHashMap<UUID, DefaultRestDirectoryEndpoint>();
    private final DefaultValuesProvider defaultValuesProvider;

    public DefaultRestClient(OpenEhrClientConfig config, TemplateProvider templateProvider) {
        this(config, templateProvider, null);
    }

    public DefaultRestClient(OpenEhrClientConfig config) {
        this(config, null, null);
    }

    public DefaultRestClient(OpenEhrClientConfig config, TemplateProvider templateProvider, HttpClient httpClient) {
        this.config = config;
        this.templateProvider = templateProvider != null ? templateProvider : new ClientTemplateProvider(this);
        this.executor = Executor.newInstance((HttpClient)httpClient);
        this.defaultRestEhrEndpoint = new DefaultRestEhrEndpoint(this);
        this.defaultValuesProvider = config.getDefaultValuesProvider() != null ? config.getDefaultValuesProvider() : o -> new DefaultValues();
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("openEHR", new Version(1, 0, 0, null, null, null));
        module.addDeserializer(AuditDetails.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(Composition.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(Contribution.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(DvCodedText.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(DvText.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(EhrStatus.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(Folder.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(HierObjectId.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(ItemStructure.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(ObjectRef.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(ObjectVersionId.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(UIDBasedId.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(RevisionHistoryItem.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        module.addDeserializer(VersionedComposition.class, (JsonDeserializer)new RmObjectJsonDeSerializer());
        objectMapper.registerModule((Module)module);
        objectMapper.registerModule((Module)new JavaTimeModule());
        return objectMapper;
    }

    protected VersionUid httpPost(URI uri, RMObject body) {
        return this.httpPost(uri, body, null);
    }

    protected VersionUid httpPost(URI uri, RMObject body, Map<String, String> headers) {
        String bodyString = new CanonicalJson().marshal(body);
        HttpResponse response = this.internalPost(uri, headers, bodyString, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON.getMimeType());
        Header eTag = response.getFirstHeader("ETag");
        return this.buildVersionUidFromETag(eTag);
    }

    private VersionUid buildVersionUidFromETag(Header eTag) {
        return new VersionUid(StringUtils.unwrap((String)StringUtils.removeStart((String)eTag.getValue(), (String)"W/"), (char)'\"'));
    }

    protected HttpResponse internalPost(URI uri, Map<String, String> headers, String bodyString, ContentType contentType, String accept) {
        HttpResponse response;
        try {
            Request request = Request.Post((URI)uri).addHeader("Accept", accept).bodyString(bodyString, contentType);
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> ((Request)request).addHeader(arg_0, arg_1));
            }
            response = this.executor.execute(request).returnResponse();
            this.checkStatus(response, 200, 201, 204);
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
        return response;
    }

    protected VersionUid httpPut(URI uri, Locatable body, VersionUid versionUid) {
        return this.httpPut(uri, body, versionUid, null);
    }

    protected VersionUid httpPut(URI uri, Locatable body, VersionUid versionUid, Map<String, String> headers) {
        try {
            Request request = Request.Put((URI)uri).addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType()).addHeader("If-Match", versionUid.toString()).bodyString(new CanonicalJson().marshal((RMObject)body), ContentType.APPLICATION_JSON);
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> ((Request)request).addHeader(arg_0, arg_1));
            }
            HttpResponse response = this.executor.execute(request).returnResponse();
            this.checkStatus(response, 200, 204, 412);
            if (412 == response.getStatusLine().getStatusCode()) {
                throw new OptimisticLockException("Entity outdated");
            }
            Header eTag = response.getFirstHeader("ETag");
            return this.buildVersionUidFromETag(eTag);
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    protected <T> Optional<T> httpGet(URI uri, Class<T> valueType) {
        return this.httpGet(uri, valueType, null);
    }

    protected <T> Optional<T> httpGet(URI uri, Class<T> valueType, Map<String, String> headers) {
        HttpResponse response = this.internalGet(uri, headers, ContentType.APPLICATION_JSON.getMimeType());
        if (response.getStatusLine().getStatusCode() == 204 || response.getStatusLine().getStatusCode() == 404) {
            return Optional.empty();
        }
        try {
            String value = EntityUtils.toString((HttpEntity)response.getEntity());
            return Optional.of(OBJECT_MAPPER.readValue(value, valueType));
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    protected HttpResponse internalGet(URI uri, Map<String, String> headers, String accept) {
        HttpResponse response;
        try {
            Request request = Request.Get((URI)uri).addHeader("Accept", accept);
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> ((Request)request).addHeader(arg_0, arg_1));
            }
            response = this.executor.execute(request).returnResponse();
            this.checkStatus(response, 200, 204, 404);
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
        return response;
    }

    protected HttpResponse internalDelete(URI uri, Map<String, String> headers) {
        HttpResponse response;
        try {
            Request request = Request.Delete((URI)uri);
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> ((Request)request).addHeader(arg_0, arg_1));
            }
            response = this.executor.execute(request).returnResponse();
            this.checkStatus(response, 200, 204, 202, 404);
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
        return response;
    }

    void checkStatus(HttpResponse httpResponse, int ... expected) {
        if (!ArrayUtils.contains((int[])expected, (int)httpResponse.getStatusLine().getStatusCode())) {
            String message = Optional.of(httpResponse).map(HttpResponse::getEntity).map(e -> {
                try {
                    return EntityUtils.toString((HttpEntity)e);
                }
                catch (IOException ex) {
                    return null;
                }
            }).orElse("");
            throw new WrongStatusCodeException(message, httpResponse.getStatusLine().getStatusCode(), expected);
        }
    }

    protected OpenEhrClientConfig getConfig() {
        return this.config;
    }

    protected DefaultValuesProvider getDefaultValuesProvider() {
        return this.defaultValuesProvider;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public DefaultRestEhrEndpoint ehrEndpoint() {
        return this.defaultRestEhrEndpoint;
    }

    TemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    @Override
    public CompositionEndpoint compositionEndpoint(UUID ehrId) {
        return new DefaultRestCompositionEndpoint(this, ehrId);
    }

    @Override
    public FolderDAO folder(UUID ehrId, String path) {
        return this.directoryEndpointMap.computeIfAbsent(ehrId, k -> new DefaultRestDirectoryEndpoint(this, (UUID)k)).getFolder(path);
    }

    @Override
    public TemplateEndpoint templateEndpoint() {
        return new DefaultRestTemplateEndpoint(this);
    }

    @Override
    public AqlEndpoint aqlEndpoint() {
        return new DefaultRestAqlEndpoint(this);
    }

    @Override
    public AdminEhrEndpoint adminEhrEndpoint() {
        return new DefaultRestAdminEhrEndpoint(this);
    }

    @Override
    public AdminTemplateEndpoint adminTemplateEndpoint() {
        return new DefaultRestAdminTemplateEndpoint(this);
    }

    @Override
    public VersionedCompositionEndpoint versionedCompositionEndpoint(UUID ehrId) {
        return new DefaultRestVersionedCompositionEndpoint(this, ehrId);
    }
}

