/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.directory.Folder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.client.openehrclient.CompositionEndpoint;
import org.ehrbase.client.openehrclient.FolderDAO;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestFolderDAO;
import org.ehrbase.response.openehr.DirectoryResponseData;

public class DefaultRestDirectoryEndpoint {
    static final String FOLDER_DIVIDER = "/";
    private static final String DIRECTORY_PATH = "/directory/";
    private final DefaultRestClient defaultRestClient;
    private final UUID ehrId;
    private VersionUid rootVersion;
    private Folder root;

    DefaultRestDirectoryEndpoint(DefaultRestClient defaultRestClient, UUID ehrId) {
        this.defaultRestClient = defaultRestClient;
        this.ehrId = ehrId;
        this.syncFromDb();
    }

    synchronized void syncFromDb() {
        if (this.root == null) {
            this.createRoot();
        }
        Optional<DirectoryResponseData> directoryResponseData = this.defaultRestClient.httpGet(this.resolve(""), DirectoryResponseData.class);
        this.copyToFolder(this.root, directoryResponseData.orElseThrow());
    }

    synchronized void saveToDb() {
        this.rootVersion = this.defaultRestClient.httpPut(this.resolve(""), (Locatable)this.root, this.rootVersion);
        this.syncFromDb();
    }

    synchronized Folder find(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return this.root;
        }
        String[] split = path.split(FOLDER_DIVIDER);
        Folder current = this.root;
        for (String folderName : split) {
            Folder newFolder = Optional.ofNullable(current).map(Folder::getFolders).flatMap(l -> l.stream().filter(f -> folderName.equals(f.getName().getValue())).findAny()).orElse(null);
            if (newFolder == null) {
                newFolder = new Folder();
                newFolder.setArchetypeNodeId("openEHR-EHR-FOLDER.generic.v1");
                newFolder.setName(new DvText(folderName));
                if (current.getFolders() == null) {
                    current.setFolders(new ArrayList());
                }
                current.addFolder(newFolder);
            }
            current = newFolder;
        }
        return current;
    }

    private void copyToFolder(Folder folder, DirectoryResponseData responseData) {
        folder.setUid(responseData.getUid());
        folder.setName(responseData.getName());
        folder.setDetails(responseData.getDetails());
        folder.setFolders(responseData.getFolders());
        folder.setItems(responseData.getItems());
    }

    private void createRoot() {
        VersionUid versionUid;
        this.root = new Folder();
        this.root.setName(new DvText("root"));
        this.root.setArchetypeNodeId("openEHR-EHR-FOLDER.generic.v1");
        this.rootVersion = versionUid = this.defaultRestClient.httpPost(this.resolve(""), (RMObject)this.root);
    }

    private URI resolve(String subPath) {
        if (StringUtils.isBlank((CharSequence)subPath)) {
            return this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + DIRECTORY_PATH);
        }
        return this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + DIRECTORY_PATH + subPath);
    }

    public FolderDAO getFolder(String path) {
        DefaultRestFolderDAO folderDAO = new DefaultRestFolderDAO(this, path);
        folderDAO.sync();
        return folderDAO;
    }

    CompositionEndpoint getCompositionEndpoint() {
        return this.defaultRestClient.compositionEndpoint(this.ehrId);
    }

    DefaultRestClient getDefaultRestClient() {
        return this.defaultRestClient;
    }

    UUID getEhrId() {
        return this.ehrId;
    }
}

