/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.openehrclient.TemplateEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.response.ehrscape.TemplateMetaDataDto;
import org.ehrbase.response.openehr.TemplatesResponseData;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestTemplateEndpoint
implements TemplateEndpoint {
    public static final String DEFINITION_TEMPLATE_ADL_1_4_PATH = "rest/openehr/v1/definition/template/adl1.4/";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DefaultRestClient defaultRestClient;

    public DefaultRestTemplateEndpoint(DefaultRestClient defaultRestClient) {
        this.defaultRestClient = defaultRestClient;
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> findTemplate(String templateId) {
        TemplateDocument templateDocument;
        try {
            URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve(new URIBuilder().setPath(this.defaultRestClient.getConfig().getBaseUri().getPath() + DEFINITION_TEMPLATE_ADL_1_4_PATH + templateId).build());
            HttpResponse httpResponse = this.defaultRestClient.internalGet(uri, null, ContentType.APPLICATION_XML.getMimeType());
            if (httpResponse.getStatusLine().getStatusCode() == 404) {
                return Optional.empty();
            }
            templateDocument = TemplateDocument.Factory.parse((InputStream)httpResponse.getEntity().getContent());
        }
        catch (IOException | URISyntaxException | XmlException e) {
            throw new ClientException(e.getMessage(), (Exception)e);
        }
        return Optional.of(templateDocument.getTemplate());
    }

    @Override
    public TemplatesResponseData findAllTemplates() {
        try {
            URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve(new URIBuilder().setPath(this.defaultRestClient.getConfig().getBaseUri().getPath() + DEFINITION_TEMPLATE_ADL_1_4_PATH).build());
            HttpResponse response = this.defaultRestClient.internalGet(uri, null, ContentType.APPLICATION_JSON.getMimeType());
            List templateResponseData = (List)DefaultRestClient.OBJECT_MAPPER.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<List<TemplateMetaDataDto>>(){});
            return new TemplatesResponseData(templateResponseData);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ClientException(e.getMessage(), e);
        }
    }

    @Override
    public void ensureExistence(String templateId) {
        Optional operationalTemplate = this.defaultRestClient.getTemplateProvider().find(templateId);
        if (!operationalTemplate.isPresent()) {
            throw new ClientException(String.format("Unknown Template with Id %s", templateId));
        }
        if (!this.findTemplate(templateId).isPresent()) {
            this.upload((OPERATIONALTEMPLATE)operationalTemplate.get());
        }
    }

    String upload(OPERATIONALTEMPLATE operationaltemplate) {
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve(DEFINITION_TEMPLATE_ADL_1_4_PATH);
        XmlOptions opts = new XmlOptions();
        opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
        HttpResponse response = this.defaultRestClient.internalPost(uri, null, operationaltemplate.xmlText(opts), ContentType.APPLICATION_XML, ContentType.APPLICATION_XML.getMimeType());
        return Optional.ofNullable(response.getFirstHeader("ETag")).map(header -> StringUtils.unwrap((String)StringUtils.removeStart((String)header.getValue(), (String)"W/"), (char)'\"')).orElse(operationaltemplate.getTemplateId().getValue());
    }
}

