/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.condition;

import org.ehrbase.client.aql.condition.And;
import org.ehrbase.client.aql.condition.Equal;
import org.ehrbase.client.aql.condition.Exists;
import org.ehrbase.client.aql.condition.GreaterOrEqual;
import org.ehrbase.client.aql.condition.GreaterThan;
import org.ehrbase.client.aql.condition.LessOrEqual;
import org.ehrbase.client.aql.condition.LessThan;
import org.ehrbase.client.aql.condition.Matches;
import org.ehrbase.client.aql.condition.Not;
import org.ehrbase.client.aql.condition.NotEqual;
import org.ehrbase.client.aql.condition.Or;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.parameter.Parameter;

public interface Condition {
    default public Condition and(Condition condition) {
        return Condition.and(this, condition);
    }

    default public Condition or(Condition condition) {
        return Condition.or(this, condition);
    }

    default public Condition not() {
        return Condition.not(this);
    }

    public static <T> Condition equal(SelectAqlField<T> field, T value) {
        return new Equal<T>(field, value);
    }

    public static <T> Condition equal(SelectAqlField<T> field, Parameter<T> parameter) {
        return new Equal<T>(field, parameter);
    }

    public static <T> Condition equal(SelectAqlField<T> field, SelectAqlField<T> compereField) {
        return new Equal<T>(field, compereField);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, T value) {
        return new NotEqual<T>(field, value);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return new NotEqual<T>(field, parameter);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, SelectAqlField<T> compereField) {
        return new NotEqual<T>(field, compereField);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, T value) {
        return new GreaterOrEqual<T>(field, value);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return new GreaterOrEqual<T>(field, parameter);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, SelectAqlField<T> compereField) {
        return new GreaterOrEqual<T>(field, compereField);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, T value) {
        return new GreaterThan<T>(field, value);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, Parameter<T> parameter) {
        return new GreaterThan<T>(field, parameter);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, SelectAqlField<T> compereField) {
        return new GreaterThan<T>(field, compereField);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, T value) {
        return new LessOrEqual<T>(field, value);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return new LessOrEqual<T>(field, parameter);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, SelectAqlField<T> compereField) {
        return new LessOrEqual<T>(field, compereField);
    }

    public static <T> Condition lessThan(SelectAqlField<T> field, T value) {
        return new LessThan<T>(field, value);
    }

    public static <T> Condition lessThan(SelectAqlField<T> field, Parameter<T> parameter) {
        return new LessThan<T>(field, parameter);
    }

    public static <T> Condition lessThan(SelectAqlField<T> field, SelectAqlField<T> compereField) {
        return new LessThan<T>(field, compereField);
    }

    public static <T> Condition matches(SelectAqlField<T> field, T ... value) {
        return new Matches<T>(field, value);
    }

    @SafeVarargs
    public static <T> Condition matches(SelectAqlField<T> field, Parameter<T> ... parameter) {
        return new Matches<T>(field, parameter);
    }

    public static Condition and(Condition condition1, Condition condition2) {
        return new And(condition1, condition2);
    }

    public static Condition or(Condition condition1, Condition condition2) {
        return new Or(condition1, condition2);
    }

    public static Condition not(Condition condition) {
        return new Not(condition);
    }

    public static Condition exists(SelectAqlField<?> field) {
        return new Exists(field);
    }

    public String buildAql(Containment var1);
}

