/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient;

import java.util.UUID;

public class VersionUid {
    private final UUID uuid;
    private final String system;
    private final long version;

    public VersionUid(String versionString) {
        String[] split = versionString.split("::");
        this.uuid = UUID.fromString(split[0]);
        if (split.length > 1) {
            this.system = split[1];
            this.version = Long.parseLong(split[2]);
        } else {
            this.system = "";
            this.version = 1L;
        }
    }

    public VersionUid(UUID uuid, String system, long version) {
        this.uuid = uuid;
        this.system = system;
        this.version = version;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getSystem() {
        return this.system;
    }

    public long getVersion() {
        return this.version;
    }

    public String toString() {
        return this.uuid.toString() + "::" + this.system + "::" + this.version;
    }
}

