/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.flattener.Flattener;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.client.openehrclient.VersionedCompositionEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.response.openehr.OriginalVersionResponseData;
import org.ehrbase.response.openehr.RevisionHistoryResponseData;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;

public class DefaultRestVersionedCompositionEndpoint
implements VersionedCompositionEndpoint {
    public static final String VERSIONED_COMPOSITION_PATH = "/versioned_composition/";
    public static final String REVISION_HISTORY_PATH = "/revision_history";
    public static final String VERSION_PATH = "/version";
    private final DefaultRestClient defaultRestClient;
    private final UUID ehrId;

    public DefaultRestVersionedCompositionEndpoint(DefaultRestClient defaultRestClient, UUID ehrId) {
        this.defaultRestClient = defaultRestClient;
        this.ehrId = ehrId;
    }

    @Override
    public Optional<VersionedComposition> find(UUID versionedObjectUid) {
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId + VERSIONED_COMPOSITION_PATH + versionedObjectUid);
        return this.defaultRestClient.httpGet(uri, VersionedComposition.class);
    }

    @Override
    public List<RevisionHistoryItem> findRevisionHistory(UUID versionedObjectUid) {
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId + VERSIONED_COMPOSITION_PATH + versionedObjectUid + REVISION_HISTORY_PATH);
        Optional<RevisionHistoryResponseData> result = this.defaultRestClient.httpGet(uri, RevisionHistoryResponseData.class);
        if (result.isEmpty()) {
            return new ArrayList<RevisionHistoryItem>();
        }
        return result.get().getRevisionHistoryItems();
    }

    @Override
    public <T> Optional<OriginalVersion<T>> findVersionById(UUID versionedObjectUid, VersionUid versionUid, Class<T> clazz) {
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId + VERSIONED_COMPOSITION_PATH + versionedObjectUid + "/version/" + versionUid.toString());
        return this.internalFindVersion(uri, clazz);
    }

    @Override
    public <T> Optional<OriginalVersion<T>> findVersionAtTime(UUID versionedObjectUid, @Nullable LocalDateTime versionAtTime, Class<T> clazz) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId + VERSIONED_COMPOSITION_PATH + versionedObjectUid + VERSION_PATH));
            if (versionAtTime != null) {
                uriBuilder.addParameter("version_at_time", versionAtTime.format(DateTimeFormatter.ISO_DATE_TIME));
            }
            return this.internalFindVersion(uriBuilder.build(), clazz);
        }
        catch (URISyntaxException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    public <T> Optional<OriginalVersion<T>> internalFindVersion(URI uri, Class<T> clazz) {
        HttpResponse response = this.defaultRestClient.internalGet(uri, null, ContentType.APPLICATION_JSON.getMimeType());
        if (response.getStatusLine().getStatusCode() == 404) {
            return Optional.empty();
        }
        try {
            TypeReference<OriginalVersionResponseData<Composition>> valueTypeRef = new TypeReference<OriginalVersionResponseData<Composition>>(){};
            return Optional.of((OriginalVersionResponseData)DefaultRestClient.OBJECT_MAPPER.readValue(response.getEntity().getContent(), (TypeReference)valueTypeRef)).map(originalVersion -> this.convert((OriginalVersionResponseData<Composition>)originalVersion, clazz));
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private <T> OriginalVersion<T> convert(OriginalVersionResponseData<Composition> originalVersion, Class<T> clazz) {
        OriginalVersion result = new OriginalVersion();
        result.setUid(originalVersion.getVersionId());
        result.setPrecedingVersionUid(originalVersion.getPrecedingVersionUid());
        result.setLifecycleState(originalVersion.getLifecycleState());
        result.setCommitAudit(originalVersion.getAuditDetails());
        result.setSignature(originalVersion.getSignature());
        result.setOtherInputVersionUids(originalVersion.getOtherInputVersionUids());
        result.setAttestations(originalVersion.getAttestations());
        T composition = this.createFlattener(this.defaultRestClient.getTemplateProvider()).flatten((RMObject)originalVersion.getData(), clazz);
        result.setData(composition);
        return result;
    }

    protected Flattener createFlattener(TemplateProvider templateProvider) {
        return new Flattener(templateProvider);
    }
}

