/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.flattener;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import org.ehrbase.building.webtemplateskeletnbuilder.WebTemplateSkeletonBuilder;
import org.ehrbase.client.annotations.Id;
import org.ehrbase.client.annotations.Template;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.flattener.DefaultValuesProvider;
import org.ehrbase.client.flattener.DtoToCompositionWalker;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;

public class Unflattener {
    private final TemplateProvider templateProvider;
    private final DefaultValuesProvider defaultValuesProvider;

    public Unflattener(TemplateProvider templateProvider, DefaultValuesProvider defaultValuesProvider) {
        this.templateProvider = templateProvider;
        this.defaultValuesProvider = defaultValuesProvider;
    }

    public Unflattener(TemplateProvider templateProvider) {
        this.defaultValuesProvider = o -> new DefaultValues();
        this.templateProvider = templateProvider;
    }

    public RMObject unflatten(Object dto) {
        Template template = dto.getClass().getAnnotation(Template.class);
        WebTemplate introspect = (WebTemplate)this.templateProvider.buildIntrospect(template.value()).orElseThrow(() -> new SdkException(String.format("Can not find Template: %s", template.value())));
        Composition generate = WebTemplateSkeletonBuilder.build((WebTemplate)introspect, (boolean)false);
        new DtoToCompositionWalker().walk(generate, DtoToCompositionWalker.findEntity(dto), introspect, this.defaultValuesProvider.provide(dto), template.value());
        Optional<VersionUid> versionUid = Unflattener.extractVersionUid(dto);
        if (versionUid.isPresent()) {
            generate.setUid((UIDBasedId)new ObjectVersionId(versionUid.get().toString()));
        }
        return generate;
    }

    static Optional<VersionUid> extractVersionUid(Object entity) {
        return Arrays.stream(entity.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(Id.class)).findAny().map(idField -> {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(idField.getName(), entity.getClass());
                return (VersionUid)propertyDescriptor.getReadMethod().invoke(entity, new Object[0]);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                throw new ClientException(e.getMessage(), e);
            }
        });
    }
}

