/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient;

import com.nedap.archie.rm.directory.Folder;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.client.openehrclient.VersionUid;

public interface DirectoryCrudEndpoint {
    public static final String FOLDER_DIVIDER = "/";

    public VersionUid createDirectory(Folder var1);

    public VersionUid updateDirectory(Folder var1);

    public Optional<Folder> getDirectory();

    public static Optional<Folder> find(Folder root, String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return Optional.ofNullable(root);
        }
        String[] split = path.split(FOLDER_DIVIDER);
        Folder current = root;
        for (String folderName : split) {
            Optional newFolder = Optional.of(current).map(Folder::getFolders).flatMap(l -> l.stream().filter(f -> folderName.equals(f.getName().getValue())).findAny());
            if (!newFolder.isPresent()) {
                return Optional.empty();
            }
            current = (Folder)newFolder.get();
        }
        return Optional.ofNullable(current);
    }
}

