/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectId;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.client.openehrclient.DirectoryCrudEndpoint;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.response.openehr.DirectoryResponseData;
import org.ehrbase.util.exception.SdkException;

public class DefaultCrudEndpoint
implements DirectoryCrudEndpoint {
    static final String DIRECTORY_PATH = "/directory/";
    private final DefaultRestClient defaultRestClient;
    private final UUID ehrId;

    public DefaultCrudEndpoint(DefaultRestClient restClient, UUID ehrId) {
        this.defaultRestClient = restClient;
        this.ehrId = ehrId;
    }

    @Override
    public VersionUid createDirectory(Folder folder) {
        return this.defaultRestClient.httpPost(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + DIRECTORY_PATH), (RMObject)folder);
    }

    @Override
    public VersionUid updateDirectory(Folder folder) {
        VersionUid versionUid = Optional.ofNullable(folder.getUid()).map(ObjectId::toString).map(VersionUid::new).orElseThrow(() -> new SdkException("Folder.uuid not set"));
        return this.defaultRestClient.httpPut(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + DIRECTORY_PATH), (Locatable)folder, versionUid);
    }

    @Override
    public Optional<Folder> getDirectory() {
        Optional<DirectoryResponseData> directoryResponseData = this.defaultRestClient.httpGet(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + DIRECTORY_PATH), DirectoryResponseData.class);
        if (directoryResponseData.isEmpty()) {
            return Optional.empty();
        }
        Folder folder = new Folder();
        DirectoryResponseData responseData = directoryResponseData.get();
        folder.setUid(responseData.getUid());
        folder.setArchetypeNodeId("openEHR-EHR-FOLDER.generic.v1");
        folder.setName(responseData.getName());
        folder.setFolders(responseData.getFolders());
        folder.setItems(responseData.getItems());
        folder.setDetails(responseData.getDetails());
        return Optional.of(folder);
    }
}

