/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.client.annotations.Template;
import org.ehrbase.client.aql.condition.Condition;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.containment.ContainmentExpression;
import org.ehrbase.client.aql.field.EhrFields;
import org.ehrbase.client.aql.field.NativeSelectAqlField;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.parameter.ParameterValue;
import org.ehrbase.client.aql.query.EntityQuery;
import org.ehrbase.client.aql.query.Query;
import org.ehrbase.client.aql.record.Record1;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.openehrclient.FolderDAO;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestCompositionEndpoint;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestDirectoryEndpoint;

public class DefaultRestFolderDAO
implements FolderDAO {
    private final DefaultRestDirectoryEndpoint directoryEndpoint;
    private final String path;

    public DefaultRestFolderDAO(DefaultRestDirectoryEndpoint directoryEndpoint, String path) {
        this.directoryEndpoint = directoryEndpoint;
        this.path = path;
    }

    @Override
    public String getName() {
        this.directoryEndpoint.syncFromDb();
        return this.getRmFolder().getName().getValue();
    }

    @Override
    public void setName(String name) {
        this.directoryEndpoint.syncFromDb();
        this.getRmFolder().setName(new DvText(name));
        this.directoryEndpoint.saveToDb();
    }

    @Override
    public Set<String> listSubFolderNames() {
        this.directoryEndpoint.syncFromDb();
        return Optional.of(this.getRmFolder()).stream().map(Folder::getFolders).filter(Objects::nonNull).flatMap(Collection::stream).map(Locatable::getName).map(DvText::getValue).collect(Collectors.toSet());
    }

    @Override
    public Folder getRmFolder() {
        return this.directoryEndpoint.find(this.path);
    }

    @Override
    public FolderDAO getSubFolder(String path) {
        DefaultRestFolderDAO folderDAO = new DefaultRestFolderDAO(this.directoryEndpoint, Stream.of(this.path, path).filter(StringUtils::isNotBlank).collect(Collectors.joining("//")));
        folderDAO.sync();
        return folderDAO;
    }

    @Override
    public <T> T addCompositionEntity(T entity) {
        T updatedEntity = this.directoryEndpoint.getCompositionEndpoint().mergeCompositionEntity(entity);
        VersionUid versionId = DefaultRestCompositionEndpoint.extractVersionUid(updatedEntity).orElseThrow(() -> new ClientException(String.format("No Id Element for %s", entity.getClass())));
        this.addToFolder(versionId);
        return updatedEntity;
    }

    @Override
    public VersionUid addRaw(Composition composition) {
        VersionUid versionId = this.directoryEndpoint.getCompositionEndpoint().mergeRaw(composition);
        this.addToFolder(versionId);
        return versionId;
    }

    @Override
    public <T> List<T> find(Class<T> clazz) {
        Containment compositionContainment = new Containment("COMPOSITION");
        EntityQuery query = Query.buildEntityQuery((ContainmentExpression)compositionContainment, (SelectAqlField)new NativeSelectAqlField(compositionContainment, "", clazz));
        query.where(Condition.equal((SelectAqlField)EhrFields.EHR_ID(), (Object)this.directoryEndpoint.getEhrId()).and(Condition.equal((SelectAqlField)new NativeSelectAqlField(compositionContainment, "/template_id", String.class), (Object)this.extractTemplateId(clazz))).and(Condition.matches((SelectAqlField)new NativeSelectAqlField(compositionContainment, "/uid/value", String.class), (Object[])((String[])this.getRmFolder().getItems().stream().map(ObjectRef::getId).map(Object::toString).toArray(String[]::new)))));
        List execute = this.directoryEndpoint.getDefaultRestClient().aqlEndpoint().execute(query, new ParameterValue[0]);
        return execute.stream().map(Record1::value1).collect(Collectors.toList());
    }

    @Override
    public List<ObjectRef<? extends ObjectId>> getItems() {
        return this.getRmFolder().getItems();
    }

    void sync() {
        this.getRmFolder();
        this.directoryEndpoint.saveToDb();
    }

    private String extractTemplateId(Class clazz) {
        Template annotation = clazz.getAnnotation(Template.class);
        return annotation.value();
    }

    private void addToFolder(VersionUid versionId) {
        this.addItemToFolder(versionId);
    }

    private void addItemToFolder(VersionUid versionId) {
        Folder folder = this.getRmFolder();
        if (folder.getItems() == null) {
            folder.setItems(new ArrayList());
        }
        folder.getItems().add(new ObjectRef((ObjectId)new ObjectVersionId(versionId.getUuid().toString()), versionId.getSystem(), "VERSIONED_COMPOSITION"));
        this.directoryEndpoint.saveToDb();
    }

    @Override
    public void addItemToRmFolder(VersionUid versionId) {
        this.addItemToFolder(versionId);
    }
}

