/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.condition;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.ehrbase.client.aql.condition.Condition;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.parameter.AqlValue;
import org.ehrbase.client.aql.parameter.Parameter;

public class Matches<T>
implements Condition {
    private final SelectAqlField<T> field;
    private final AqlValue[] values;
    private final Parameter<T>[] parameters;

    Matches(SelectAqlField<T> field, T ... values) {
        this.field = field;
        this.values = (AqlValue[])Arrays.stream(values).map(AqlValue::new).toArray(AqlValue[]::new);
        this.parameters = null;
    }

    Matches(SelectAqlField<T> field, Parameter<T> ... parameters) {
        this.field = field;
        this.values = null;
        this.parameters = parameters;
    }

    @Override
    public String buildAql(Containment ehrContainment) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field.buildAQL(ehrContainment)).append(" matches {");
        if (this.values != null) {
            sb.append(Arrays.stream(this.values).map(AqlValue::buildAql).collect(Collectors.joining(",")));
        } else {
            sb.append(Arrays.stream(this.parameters).map(Parameter::getAqlParameter).collect(Collectors.joining(",")));
        }
        sb.append("}");
        return sb.toString();
    }
}

