/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.field;

import java.util.List;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;

public class AqlFieldImp<T>
implements SelectAqlField<T> {
    private final String name;
    private final String path;
    private final Class<T> valueClass;
    private final Class<?> entityClass;
    private final Containment containment;
    private final boolean multiValued;

    protected AqlFieldImp(Class<T> clazz) {
        this.valueClass = clazz;
        this.name = null;
        this.path = null;
        this.entityClass = null;
        this.containment = null;
        this.multiValued = List.class.isAssignableFrom(clazz);
    }

    public AqlFieldImp(Class<?> entityClass, String path, String name, Class<T> valueClass, Containment containment) {
        this.name = name;
        this.path = path;
        this.valueClass = valueClass;
        this.entityClass = entityClass;
        this.containment = containment;
        this.multiValued = false;
    }

    protected AqlFieldImp(Class<?> entityClass, String path, String name, Class<T> valueClass, boolean multiValued, Containment containment) {
        this.name = name;
        this.path = path;
        this.valueClass = valueClass;
        this.entityClass = entityClass;
        this.multiValued = multiValued;
        this.containment = containment;
    }

    @Override
    public Containment getContainment() {
        return this.containment;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public String buildAQL(Containment ehrContainment) {
        String variableName = this.containment.getTypeName().equals("EHR") ? ehrContainment.getVariableName() : this.containment.getVariableName();
        return variableName + this.path.replace("|", "/");
    }
}

