/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.flattener;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.webtemplate.parser.FlatPath;

public class PathExtractor {
    private String childPath;
    private String attributeName;
    private String parentPath;
    private String childName;

    public PathExtractor(String path) {
        this.childPath = path;
        this.invoke();
    }

    public String getChildPath() {
        return this.childPath;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getChildName() {
        return this.childName;
    }

    private void invoke() {
        FlatPath flatPath = new FlatPath(this.childPath);
        while (flatPath.getChild() != null) {
            flatPath = flatPath.getChild();
        }
        this.parentPath = StringUtils.remove((String)this.childPath, (String)flatPath.toString());
        if (StringUtils.isBlank((CharSequence)this.parentPath)) {
            this.parentPath = "/";
        }
        this.childPath = StringUtils.remove((String)this.childPath, (String)Optional.ofNullable(flatPath.getAttributeName()).map(s -> "|" + s).orElse(""));
        this.childName = flatPath.getName();
        this.attributeName = flatPath.getAttributeName();
    }
}

