/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectId;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.ehrbase.client.annotations.Id;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.flattener.Flattener;
import org.ehrbase.client.flattener.Unflattener;
import org.ehrbase.client.openehrclient.CompositionEndpoint;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestClient;

public class DefaultRestCompositionEndpoint
implements CompositionEndpoint {
    public static final String COMPOSITION_PATH = "/composition/";
    private final DefaultRestClient defaultRestClient;
    private final UUID ehrId;

    public DefaultRestCompositionEndpoint(DefaultRestClient defaultRestClient, UUID ehrId) {
        this.defaultRestClient = defaultRestClient;
        this.ehrId = ehrId;
    }

    static Optional<VersionUid> extractVersionUid(Object entity) {
        return Arrays.stream(FieldUtils.getAllFields(entity.getClass())).filter(f -> f.isAnnotationPresent(Id.class)).findAny().map(idField -> {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(idField.getName(), entity.getClass());
                return (VersionUid)propertyDescriptor.getReadMethod().invoke(entity, new Object[0]);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                throw new ClientException(e.getMessage(), e);
            }
        });
    }

    @Override
    public <T> T mergeCompositionEntity(T entity) {
        Composition composition = (Composition)new Unflattener(this.defaultRestClient.getTemplateProvider(), this.defaultRestClient.getDefaultValuesProvider()).unflatten(entity);
        Optional<VersionUid> versionUid = DefaultRestCompositionEndpoint.extractVersionUid(entity);
        VersionUid updatedVersion = this.internalMerge(composition, versionUid.orElse(null));
        Flattener.addVersion(entity, updatedVersion);
        entity = new Flattener(this.defaultRestClient.getTemplateProvider()).flatten((RMObject)composition, entity.getClass());
        Flattener.addVersion(entity, updatedVersion);
        return entity;
    }

    private VersionUid internalMerge(Composition composition, VersionUid versionUid) {
        VersionUid updatedVersion = versionUid == null ? this.defaultRestClient.httpPost(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH), (RMObject)composition) : this.defaultRestClient.httpPut(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH + versionUid.getUuid()), (Locatable)composition, versionUid);
        return updatedVersion;
    }

    @Override
    public VersionUid mergeRaw(Composition composition) {
        Optional<VersionUid> versionUid = Optional.ofNullable(composition.getUid()).map(ObjectId::toString).map(VersionUid::new);
        VersionUid newVersionUid = this.internalMerge(composition, versionUid.orElse(null));
        return newVersionUid;
    }

    @Override
    public <T> Optional<T> find(UUID compositionId, Class<T> clazz) {
        Optional<Composition> composition = this.findRaw(compositionId);
        return composition.map(c -> new Flattener(this.defaultRestClient.getTemplateProvider()).flatten((RMObject)c, clazz));
    }

    @Override
    public Optional<Composition> findRaw(UUID compositionId) {
        Optional<Composition> composition = this.defaultRestClient.httpGet(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH + compositionId.toString()), Composition.class);
        return composition;
    }

    @Override
    public void delete(VersionUid precedingVersionUid) {
        if (precedingVersionUid == null) {
            throw new ClientException("precedingVersionUid mush not be null");
        }
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH + precedingVersionUid);
        this.defaultRestClient.internalDelete(uri, new HashMap<String, String>());
    }
}

