/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.ehrbase.openehr.sdk.client.openehrclient.AqlEndpoint;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.TemporalAccessorDeSerializer;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Entity;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.AqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.ListSelectAqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.parameter.ParameterValue;
import org.ehrbase.openehr.sdk.generator.commons.aql.parameter.StoredQueryParameter;
import org.ehrbase.openehr.sdk.generator.commons.aql.query.Query;
import org.ehrbase.openehr.sdk.generator.commons.aql.record.Record;
import org.ehrbase.openehr.sdk.generator.commons.aql.record.RecordImp;
import org.ehrbase.openehr.sdk.generator.commons.interfaces.EnumValueSet;
import org.ehrbase.openehr.sdk.response.dto.QueryResponseData;
import org.ehrbase.openehr.sdk.response.dto.StoredQueryResponseData;
import org.ehrbase.openehr.sdk.serialisation.dto.RmToGeneratedDtoConverter;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.util.exception.ClientException;
import org.ehrbase.openehr.sdk.webtemplate.templateprovider.TemplateProvider;
import org.json.JSONObject;

public class DefaultRestAqlEndpoint
implements AqlEndpoint {
    public static final String AQL_PATH = "rest/openehr/v1/query/aql/";
    public static final String AQL_STORED_QUERY_PATH = "rest/openehr/v1/query/";
    public static final String STORE_AQL_QUERY_PATH = "rest/openehr/v1/definition/query/";
    public static final String QUERY_MAP_KEY = "q";
    public static final ObjectMapper AQL_OBJECT_MAPPER = DefaultRestAqlEndpoint.buildAqlObjectMapper();
    private final DefaultRestClient defaultRestClient;
    private static final String INVALID_QUERY_ERROR_STRING = "Invalid query";
    private static final String INVALID_PARAMETERS_ERROR_STRING = "Invalid parameters";

    public DefaultRestAqlEndpoint(DefaultRestClient defaultRestClient) {
        this.defaultRestClient = defaultRestClient;
    }

    private static ObjectMapper buildAqlObjectMapper() {
        ObjectMapper objectMapper = ArchieObjectMapperProvider.getObjectMapper().copy();
        SimpleModule module = new SimpleModule("openEHR", new Version(1, 0, 0, null, null, null));
        module.addDeserializer(TemporalAccessor.class, (JsonDeserializer)new TemporalAccessorDeSerializer());
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    @Override
    public <T extends Record> List<T> execute(Query<T> query, ParameterValue ... parameterValues) {
        ArrayList<RecordImp> result = new ArrayList<RecordImp>();
        HashMap<String, String> qMap = new HashMap<String, String>();
        String aql = query.buildAql();
        for (ParameterValue v : parameterValues) {
            aql = aql.replace(v.getParameter().getAqlParameter(), v.buildAql());
        }
        qMap.put(QUERY_MAP_KEY, aql);
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve(AQL_PATH);
        try {
            HttpResponse response = this.defaultRestClient.internalPost(uri, null, DefaultRestClient.OBJECT_MAPPER.writeValueAsString(qMap), ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON.getMimeType());
            String value = EntityUtils.toString((HttpEntity)response.getEntity());
            QueryResponseData queryResponseData = (QueryResponseData)AQL_OBJECT_MAPPER.readValue(value, QueryResponseData.class);
            List dataRows = queryResponseData.getRows();
            if (Objects.nonNull(dataRows)) {
                for (List jresult : dataRows) {
                    RecordImp record = new RecordImp(query.fields());
                    int i = 0;
                    for (AqlField aqlField : query.fields()) {
                        ArrayList<Object> object;
                        String valueAsString = AQL_OBJECT_MAPPER.writeValueAsString(jresult.get(i));
                        Class aClass = aqlField.getValueClass();
                        if (ListSelectAqlField.class.isAssignableFrom(aqlField.getClass())) {
                            ArrayList<Object> list;
                            object = list = new ArrayList<Object>();
                            list.add(this.extractValue(valueAsString, ((ListSelectAqlField)aqlField).getInnerClass()));
                        } else {
                            object = this.extractValue(valueAsString, aClass);
                        }
                        record.putValue(i, object);
                        ++i;
                    }
                    result.add(record);
                }
            }
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), (Exception)e);
        }
        return result;
    }

    @Override
    public QueryResponseData executeRaw(Query query, ParameterValue ... parameters) {
        if (query == null) {
            throw new ClientException(INVALID_QUERY_ERROR_STRING);
        }
        if (parameters == null) {
            throw new ClientException(INVALID_PARAMETERS_ERROR_STRING);
        }
        String queryString = query.buildAql();
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            throw new ClientException(INVALID_QUERY_ERROR_STRING);
        }
        for (ParameterValue v : parameters) {
            queryString = queryString.replace(v.getParameter().getAqlParameter(), v.buildAql());
        }
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve(AQL_PATH);
        try {
            String body = DefaultRestClient.OBJECT_MAPPER.writeValueAsString(Map.of(QUERY_MAP_KEY, queryString));
            HttpResponse response = this.defaultRestClient.internalPost(uri, Collections.emptyMap(), body, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON.getMimeType());
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity());
            return (QueryResponseData)DefaultRestClient.OBJECT_MAPPER.readValue(responseJson, QueryResponseData.class);
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), (Exception)e);
        }
    }

    @Override
    public QueryResponseData executeStoredQuery(StoredQueryParameter queryParameter) {
        if (queryParameter == null || !queryParameter.isValid()) {
            throw new ClientException(INVALID_QUERY_ERROR_STRING);
        }
        URIBuilder uriBuilder = this.getBaseUriBuilder().setPath(this.defaultRestClient.getConfig().getBaseUri().getPath() + AQL_STORED_QUERY_PATH + queryParameter.getPath());
        queryParameter.getOffset().ifPresent(value -> uriBuilder.addParameter("offset", value.toString()));
        queryParameter.getFetch().ifPresent(value -> uriBuilder.addParameter("fetch", value.toString()));
        for (Map.Entry param : queryParameter.getQueryParams().entrySet()) {
            uriBuilder.addParameter((String)param.getKey(), (String)param.getValue());
        }
        try {
            HttpResponse response = this.defaultRestClient.internalGet(uriBuilder.build(), Collections.emptyMap(), ContentType.APPLICATION_JSON.getMimeType());
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity());
            return (QueryResponseData)DefaultRestClient.OBJECT_MAPPER.readValue(responseJson, QueryResponseData.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    @Override
    public StoredQueryResponseData getStoredAqlQuery(StoredQueryParameter queryParameter) {
        if (queryParameter == null || !queryParameter.isValid()) {
            throw new ClientException(INVALID_QUERY_ERROR_STRING);
        }
        URIBuilder uriBuilder = this.getBaseUriBuilder().setPath(this.defaultRestClient.getConfig().getBaseUri().getPath() + AQL_STORED_QUERY_PATH + queryParameter.getPath());
        try {
            HttpResponse response = this.defaultRestClient.internalGet(uriBuilder.build(), Collections.emptyMap(), ContentType.APPLICATION_JSON.getMimeType());
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity());
            return (StoredQueryResponseData)DefaultRestClient.OBJECT_MAPPER.readValue(responseJson, StoredQueryResponseData.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    @Override
    public void storeAqlQuery(Query query, StoredQueryParameter queryParameter) {
        if (query == null) {
            throw new ClientException(INVALID_QUERY_ERROR_STRING);
        }
        if (queryParameter == null || !queryParameter.isValid()) {
            throw new ClientException(INVALID_PARAMETERS_ERROR_STRING);
        }
        JSONObject requestBody = new JSONObject();
        requestBody.put(QUERY_MAP_KEY, (Object)query.buildAql());
        URIBuilder uriBuilder = this.getBaseUriBuilder().setPath(this.defaultRestClient.getConfig().getBaseUri().getPath() + STORE_AQL_QUERY_PATH + queryParameter.getPath());
        queryParameter.getType().ifPresent(type -> uriBuilder.addParameter("type", type));
        try {
            this.defaultRestClient.internalPut(uriBuilder.build(), Collections.emptyMap(), requestBody.toString(), ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (URISyntaxException e) {
            throw new ClientException(e.getMessage(), (Exception)e);
        }
    }

    private URIBuilder getBaseUriBuilder() {
        URI baseUri = this.defaultRestClient.getConfig().getBaseUri();
        return new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort());
    }

    private Object extractValue(String valueAsString, Class<?> aClass) throws JsonProcessingException {
        Object object;
        if (StringUtils.isBlank((CharSequence)valueAsString) || "null".equals(valueAsString)) {
            object = null;
        } else if (aClass.isAnnotationPresent(Entity.class)) {
            RMObject locatable = (RMObject)AQL_OBJECT_MAPPER.readValue(valueAsString, RMObject.class);
            object = this.createFlattener(this.defaultRestClient.getTemplateProvider()).toGeneratedDto(locatable, aClass);
            if (locatable instanceof Composition) {
                RmToGeneratedDtoConverter.addVersion((Object)object, (ObjectVersionId)new ObjectVersionId(((Composition)locatable).getUid().getValue()));
            }
        } else if (EnumValueSet.class.isAssignableFrom(aClass)) {
            RMObject rmObject = (RMObject)AQL_OBJECT_MAPPER.readValue(valueAsString, RMObject.class);
            String codeString = CodePhrase.class.isAssignableFrom(rmObject.getClass()) ? ((CodePhrase)rmObject).getCodeString() : ((DvCodedText)rmObject).getDefiningCode().getCodeString();
            object = Arrays.stream(aClass.getEnumConstants()).map(e -> (EnumValueSet)e).filter(e -> e.getCode().equals(codeString)).findAny().orElseThrow(() -> new ClientException(String.format("Unknown code %s for %s", codeString, aClass.getSimpleName())));
        } else {
            object = AQL_OBJECT_MAPPER.readValue(valueAsString, aClass);
        }
        return object;
    }

    protected RmToGeneratedDtoConverter createFlattener(TemplateProvider templateProvider) {
        return new RmToGeneratedDtoConverter(templateProvider);
    }
}

