/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.ehrbase.openehr.sdk.client.openehrclient.CompositionEndpoint;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Id;
import org.ehrbase.openehr.sdk.serialisation.dto.GeneratedDtoToRmConverter;
import org.ehrbase.openehr.sdk.serialisation.dto.RmToGeneratedDtoConverter;
import org.ehrbase.openehr.sdk.util.exception.ClientException;
import org.ehrbase.openehr.sdk.webtemplate.templateprovider.TemplateProvider;

public class DefaultRestCompositionEndpoint
implements CompositionEndpoint {
    public static final String COMPOSITION_PATH = "/composition/";
    private final DefaultRestClient defaultRestClient;
    private final UUID ehrId;

    public DefaultRestCompositionEndpoint(DefaultRestClient defaultRestClient, UUID ehrId) {
        this.defaultRestClient = defaultRestClient;
        this.ehrId = ehrId;
    }

    static Optional<ObjectVersionId> extractVersionUid(Object entity) {
        return Arrays.stream(FieldUtils.getAllFields(entity.getClass())).filter(f -> f.isAnnotationPresent(Id.class)).findAny().map(idField -> {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(idField.getName(), entity.getClass());
                return (ObjectVersionId)propertyDescriptor.getReadMethod().invoke(entity, new Object[0]);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                throw new ClientException(e.getMessage(), e);
            }
        });
    }

    @Override
    public <T> T mergeCompositionEntity(T entity) {
        Composition composition = (Composition)new GeneratedDtoToRmConverter(this.defaultRestClient.getTemplateProvider(), this.defaultRestClient.getDefaultValuesProvider()).toRMObject(entity);
        Optional<ObjectVersionId> versionUid = DefaultRestCompositionEndpoint.extractVersionUid(entity);
        ObjectVersionId updatedVersion = this.internalMerge(composition, versionUid.orElse(null));
        RmToGeneratedDtoConverter.addVersion(entity, (ObjectVersionId)updatedVersion);
        entity = this.createFlattener(this.defaultRestClient.getTemplateProvider()).toGeneratedDto((RMObject)composition, entity.getClass());
        RmToGeneratedDtoConverter.addVersion(entity, (ObjectVersionId)updatedVersion);
        return entity;
    }

    private ObjectVersionId internalMerge(Composition composition, ObjectVersionId versionUid) {
        ObjectVersionId updatedVersion = versionUid == null ? this.defaultRestClient.httpPost(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH), (RMObject)composition) : this.defaultRestClient.httpPut(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH + versionUid.getObjectId().getValue()), (Locatable)composition, versionUid);
        return updatedVersion;
    }

    @Override
    public ObjectVersionId mergeRaw(Composition composition) {
        Optional<ObjectVersionId> versionUid = Optional.ofNullable(composition.getUid()).map(ObjectId::toString).map(ObjectVersionId::new);
        return this.internalMerge(composition, versionUid.orElse(null));
    }

    @Override
    public <T> Optional<T> find(UUID compositionId, Class<T> clazz) {
        Optional<Composition> composition = this.findRaw(compositionId);
        return composition.map(c -> this.createFlattener(this.defaultRestClient.getTemplateProvider()).toGeneratedDto((RMObject)c, clazz));
    }

    @Override
    public Optional<Composition> findRaw(UUID compositionId) {
        return this.defaultRestClient.httpGet(this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH + compositionId.toString()), Composition.class);
    }

    @Override
    public void delete(ObjectVersionId precedingVersionUid) {
        if (precedingVersionUid == null) {
            throw new ClientException("precedingVersionUid mush not be null");
        }
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + COMPOSITION_PATH + precedingVersionUid);
        this.defaultRestClient.internalDelete(uri, new HashMap<String, String>());
    }

    protected RmToGeneratedDtoConverter createFlattener(TemplateProvider templateProvider) {
        return new RmToGeneratedDtoConverter(templateProvider);
    }
}

