/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.client.openehrclient.builder;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.client.openehrclient.ContributionChangeType;
import org.ehrbase.openehr.sdk.response.dto.ContributionCreateDto;

public class ContributionBuilder {
    private static final String CONTRIBUTION_MUST_HAVE_AT_LEAST_ONE_VERSION_OBJECT = "Invalid Contribution, must have at least one Version object.";
    private static final String MISSING_ORIGINAL_VERSION = "Missing mandatory OriginalVersion Locatable.";
    private static final String MISSING_MANDATORY_CONTRIBUTOR_AUDIT_DETAILS = "Missing mandatory contributor AuditDetails.";
    private static final String MISSING_MANDATORY_PRECEDING_VERSION_UID = "Missing mandatory precedingVersionUid.";
    private static final String INVALID_PRECEDING_VERSION_UID_IN_VERSION_CONTAINER = "Input invalid. Composition can't be modified without pointer to precedingVersionUid in Version container.";
    private final ContributionCreateDto contributionCreateDto = new ContributionCreateDto();

    public static ContributionBuilder builder(AuditDetails audit) {
        return new ContributionBuilder(audit);
    }

    ContributionBuilder(AuditDetails audit) {
        this.contributionCreateDto.setAudit(audit);
    }

    public ContributionBuilder addFolderCreation(Folder folder) {
        this.updateContribution((Locatable)folder, ContributionChangeType.CREATION, null);
        return this;
    }

    public ContributionBuilder addFolderDeletion(Folder folder, String precedingVersionUid) {
        this.updateContribution((Locatable)folder, ContributionChangeType.DELETED, precedingVersionUid);
        return this;
    }

    public ContributionBuilder addFolderModification(Folder folder) {
        this.updateContribution((Locatable)folder, ContributionChangeType.MODIFICATION, null);
        return this;
    }

    public ContributionBuilder addFolderModification(Folder folder, String precedingVersionUid) {
        this.updateContribution((Locatable)folder, ContributionChangeType.MODIFICATION, precedingVersionUid);
        return this;
    }

    public ContributionBuilder addCompositionCreation(Composition composition) {
        this.updateContribution((Locatable)composition, ContributionChangeType.CREATION, null);
        return this;
    }

    public ContributionBuilder addCompositionModification(Composition composition) {
        this.updateContribution((Locatable)composition, ContributionChangeType.MODIFICATION, null);
        return this;
    }

    public ContributionBuilder addCompositionModification(Composition composition, String precedingVersionUid) {
        this.updateContribution((Locatable)composition, ContributionChangeType.MODIFICATION, precedingVersionUid);
        return this;
    }

    public ContributionBuilder addCompositionDeletion(String precedingVersionUid) {
        this.updateContribution(null, ContributionChangeType.DELETED, precedingVersionUid);
        return this;
    }

    private void updateContribution(Locatable composition, ContributionChangeType type, String precedingVersionUid) {
        this.updateContribution(composition, type, precedingVersionUid, (OriginalVersion<Locatable>)new OriginalVersion());
    }

    private void updateContribution(Locatable composition, ContributionChangeType type, String precedingVersionUid, OriginalVersion<Locatable> originalVersion) {
        if (originalVersion == null) {
            throw new IllegalArgumentException(MISSING_ORIGINAL_VERSION);
        }
        AuditDetails compositionAudit = this.getCompositionAudit();
        UIDBasedId versionId = null;
        if (composition != null) {
            versionId = composition.getUid();
        }
        if (StringUtils.isNotBlank((CharSequence)(precedingVersionUid = ContributionBuilder.updateCompositionChangeType(type, precedingVersionUid, compositionAudit, versionId)))) {
            originalVersion.setPrecedingVersionUid(new ObjectVersionId(precedingVersionUid));
        }
        if (originalVersion.getData() == null) {
            originalVersion.setData((Object)composition);
        }
        ContributionBuilder.updateMetadataById(precedingVersionUid, originalVersion, compositionAudit);
        originalVersion.setCommitAudit(compositionAudit);
        originalVersion.setLifecycleState(new DvCodedText("complete", new CodePhrase(new TerminologyId("openehr"), "532")));
        this.contributionCreateDto.getVersions().add(originalVersion);
    }

    private AuditDetails getCompositionAudit() {
        AuditDetails audit = this.contributionCreateDto.getAudit();
        if (audit == null) {
            throw new IllegalArgumentException(MISSING_MANDATORY_CONTRIBUTOR_AUDIT_DETAILS);
        }
        return (AuditDetails)audit.clone();
    }

    private static String updateCompositionChangeType(ContributionChangeType type, String precedingVersionUid, AuditDetails compositionAudit, UIDBasedId versionId) {
        switch (type) {
            case CREATION: {
                ContributionBuilder.modifyCompositionChangeType(compositionAudit, ContributionChangeType.CREATION);
                break;
            }
            case AMENDMENT: 
            case MODIFICATION: {
                if (versionId != null && StringUtils.isNotBlank((CharSequence)versionId.getValue()) && StringUtils.isBlank((CharSequence)precedingVersionUid)) {
                    precedingVersionUid = versionId.getValue();
                }
                if (StringUtils.isBlank((CharSequence)precedingVersionUid)) {
                    throw new IllegalArgumentException(MISSING_MANDATORY_PRECEDING_VERSION_UID);
                }
                ContributionBuilder.modifyCompositionChangeType(compositionAudit, ContributionChangeType.MODIFICATION);
                break;
            }
            case DELETED: {
                if (StringUtils.isBlank((CharSequence)precedingVersionUid)) {
                    throw new IllegalArgumentException(MISSING_MANDATORY_PRECEDING_VERSION_UID);
                }
                ContributionBuilder.modifyCompositionChangeType(compositionAudit, ContributionChangeType.DELETED);
                break;
            }
            default: {
                ContributionBuilder.modifyCompositionChangeType(compositionAudit, ContributionChangeType.UNKNOWN);
            }
        }
        return precedingVersionUid;
    }

    private static void updateMetadataById(String precedingVersionUid, OriginalVersion<Locatable> originalVersion, AuditDetails compositionAudit) {
        if (originalVersion.getData() == null) {
            ContributionBuilder.modifyCompositionChangeType(compositionAudit, ContributionChangeType.DELETED);
            if (StringUtils.isBlank((CharSequence)precedingVersionUid)) {
                throw new IllegalArgumentException(INVALID_PRECEDING_VERSION_UID_IN_VERSION_CONTAINER);
            }
        }
    }

    private static void modifyCompositionChangeType(AuditDetails audit, ContributionChangeType type) {
        audit.getChangeType().setValue(type.getName());
        audit.getChangeType().getDefiningCode().setCodeString(String.valueOf(type.getCode()));
    }

    public ContributionCreateDto build() {
        if (this.contributionCreateDto.getVersions() == null || this.contributionCreateDto.getVersions().isEmpty()) {
            throw new IllegalArgumentException(CONTRIBUTION_MUST_HAVE_AT_LEAST_ONE_VERSION_OBJECT);
        }
        return this.contributionCreateDto;
    }
}

