/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.Contribution;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.ehrbase.openehr.sdk.client.openehrclient.ContributionEndpoint;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.openehr.sdk.response.dto.ContributionCreateDto;
import org.ehrbase.openehr.sdk.serialisation.RMDataFormat;
import org.ehrbase.openehr.sdk.util.exception.ClientException;

public class DefaultRestContributionEndpoint
implements ContributionEndpoint {
    public static final String CONTRIBUTION_PATH = "/contribution/";
    private final DefaultRestClient defaultRestClient;
    private final UUID ehrId;

    public DefaultRestContributionEndpoint(DefaultRestClient defaultRestClient, UUID ehrId) {
        this.defaultRestClient = defaultRestClient;
        this.ehrId = ehrId;
    }

    @Override
    public UUID saveContribution(ContributionCreateDto contribution) {
        URI baseUri = this.defaultRestClient.getConfig().getBaseUri();
        return UUID.fromString(this.defaultRestClient.httpPost(baseUri.resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + CONTRIBUTION_PATH), (RMObject)contribution).getRoot().getValue());
    }

    @Override
    public Optional<Contribution> find(UUID contributionId) {
        URI uri = this.defaultRestClient.getConfig().getBaseUri().resolve("rest/openehr/v1/ehr/" + this.ehrId.toString() + CONTRIBUTION_PATH + contributionId.toString());
        HttpResponse response = this.defaultRestClient.internalGet(uri, null, ContentType.APPLICATION_JSON.getMimeType());
        try {
            String body = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return Optional.of((Contribution)RMDataFormat.canonicalJSON().unmarshal(body, Contribution.class));
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), (Exception)e);
        }
    }
}

