/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.client.openehrclient;

import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public interface DirectoryCrudEndpoint {
    public static final String FOLDER_DIVIDER = "/";

    public ObjectVersionId createDirectory(Folder var1);

    public ObjectVersionId updateDirectory(Folder var1);

    public Optional<Folder> getDirectory();

    public static Optional<Folder> find(Folder root, String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return Optional.ofNullable(root);
        }
        String[] split = path.split(FOLDER_DIVIDER);
        Folder current = root;
        for (String folderName : split) {
            Optional newFolder = Optional.of(current).map(Folder::getFolders).flatMap(l -> l.stream().filter(f -> folderName.equals(f.getName().getValue())).findAny());
            if (!newFolder.isPresent()) {
                return Optional.empty();
            }
            current = (Folder)newFolder.get();
        }
        return Optional.ofNullable(current);
    }
}

