/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.ehrbase.openehr.sdk.generator.ClassGeneratorConfig;
import org.ehrbase.openehr.sdk.util.SnakeCase;
import org.ehrbase.openehr.sdk.util.reflection.ReflectionHelper;
import org.ehrbase.openehr.sdk.webtemplate.filter.Filter;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.parser.config.RmIntrospectConfig;
import org.ehrbase.openehr.sdk.webtemplate.util.WebTemplateUtils;

public class ClassGeneratorFilter
extends Filter {
    private static final Map<Class<?>, RmIntrospectConfig> configMap = ReflectionHelper.buildMap(RmIntrospectConfig.class);
    private ClassGeneratorConfig config;

    public ClassGeneratorFilter(ClassGeneratorConfig config) {
        this.config = config;
    }

    protected boolean skip(WebTemplateNode node, WebTemplate context, Deque<WebTemplateNode> deque) {
        WebTemplateNode parent = deque.peek();
        if (this.isTrivialNode(node, parent)) {
            return true;
        }
        if (parent != null) {
            SetUtils.SetView difference;
            RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(parent.getRmType());
            Set attributeNames = Optional.ofNullable(configMap.get(typeInfo.getJavaClass())).map(RmIntrospectConfig::getNonTemplateFields).orElse(Collections.emptySet()).stream().map(s -> new SnakeCase(s).camelToSnake()).collect(Collectors.toSet());
            attributeNames.addAll(Set.of("context", "timing", "expiry_time", "lower", "upper", "ism_transition", "location", "lower_included", "upper_included", "sample_count"));
            deque.poll();
            if (!this.isTrivialNode(parent, deque.peek()) && Locatable.class.isAssignableFrom(typeInfo.getJavaClass())) {
                attributeNames.add("feeder_audit");
            }
            deque.push(parent);
            if (this.config.isAddNullFlavor()) {
                attributeNames.add("null_flavour");
            }
            if ((difference = SetUtils.difference(typeInfo.getAttributes().keySet(), attributeNames)).contains((Object)node.getName())) {
                return true;
            }
        }
        return false;
    }

    private boolean isTrivialNode(WebTemplateNode node, WebTemplateNode parent) {
        boolean commonConditions;
        boolean bl = commonConditions = !node.getChildren().isEmpty() && node.getMax() == 1 && this.isSkippableInterval(parent, node) && (!this.isEvent(node) || this.isSkippableEvent(parent, node));
        if (!commonConditions) {
            return false;
        }
        switch (this.config.getOptimizerSetting()) {
            case ALL: {
                return !node.getRmType().equals("COMPOSITION");
            }
            case SECTION: {
                return !node.isArchetype() || node.getRmType().equals("SECTION");
            }
        }
        return !node.isArchetype();
    }

    private boolean isSkippableEvent(WebTemplateNode parent, WebTemplateNode node) {
        if (node.getRmType().equals("EVENT") && (this.config.isGenerateChoicesForSingleEvent() || node.isMulti())) {
            return false;
        }
        return !node.isMulti() && parent.getChildren().stream().filter(x$0 -> this.isEvent((WebTemplateNode)x$0)).count() == 1L;
    }

    private boolean isSkippableInterval(WebTemplateNode parent, WebTemplateNode node) {
        if (parent != null && parent.getRmType().equals("ELEMENT") && node.getRmType().startsWith("DV_INTERVAL")) {
            return WebTemplateUtils.getTrueChildrenElement((WebTemplateNode)parent).size() == 1;
        }
        return true;
    }

    protected void preHandle(WebTemplateNode node) {
        List ismTransitionList;
        if (node.getAqlPathDto().getLastNode().getName().equals("null_flavour")) {
            node.setName("null_flavour");
        }
        if (!(ismTransitionList = node.getChildren().stream().filter(n -> "ISM_TRANSITION".equals(n.getRmType())).collect(Collectors.toList())).isEmpty()) {
            node.getChildren().removeAll(ismTransitionList);
            node.getChildren().add((WebTemplateNode)ismTransitionList.get(0));
        }
    }
}

