/*
 * Copyright (c) 2019 vitasystems GmbH and Hannover Medical School.
 *
 * This file is part of project openEHR_SDK
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ehrbase.response.openehr;

import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Error according to: https://specifications.openehr.org/releases/ITS-REST/latest/ehr.html#design-considerations-http-status-codes
 */
@XmlRootElement
public class ErrorResponseData {
    String message;
    Integer code;
    List<String> errors;
    // TODO should actually be DvCodedText but makes swagger-ui fail right with: Maximum call stack size exceeded
    // List<DvCodedText> errors;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public List<String> getErrors() {
        return errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
}
