/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.response.openehr;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ehrbase.response.ehrscape.QueryResultDto;
import org.ehrbase.response.ehrscape.query.ResultHolder;
import org.ehrbase.response.openehr.MetaData;

@JacksonXmlRootElement
public class QueryResponseData {
    private MetaData meta;
    @JsonProperty(value="q")
    private String query;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonProperty(value="columns")
    private List<Map<String, String>> columns;
    @JsonProperty(value="rows")
    private List<List<Object>> rows;

    public QueryResponseData(QueryResultDto queryResultDto) {
        this.query = queryResultDto.getExecutedAQL();
        this.name = null;
        this.columns = new ArrayList<Map<String, String>>();
        this.rows = new ArrayList<List<Object>>();
        if (!queryResultDto.variablesIsEmpty()) {
            if (!queryResultDto.getResultSet().isEmpty()) {
                ResultHolder record = queryResultDto.getResultSet().get(0);
                int count = 0;
                for (String columnId : record.columnIds()) {
                    HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                    if (queryResultDto.variablesContainsColumnId(columnId)) {
                        fieldMap.put("name", columnId);
                        fieldMap.put("path", queryResultDto.variablesPath(columnId));
                    } else {
                        fieldMap.put("name", "#" + count);
                        fieldMap.put("path", columnId);
                    }
                    ++count;
                    this.columns.add(fieldMap);
                }
            } else {
                int count = 0;
                Iterator<Map.Entry<String, String>> variablesIterator = queryResultDto.variablesIterator();
                while (variablesIterator.hasNext()) {
                    HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                    Map.Entry<String, String> variableEntry = variablesIterator.next();
                    if (variableEntry.getKey() != null) {
                        fieldMap.put("name", variableEntry.getKey());
                        fieldMap.put("path", variableEntry.getValue());
                    } else {
                        fieldMap.put("name", "#" + count);
                        fieldMap.put("path", variableEntry.getValue());
                    }
                    ++count;
                    this.columns.add(fieldMap);
                }
            }
            for (ResultHolder valueSet : queryResultDto.getResultSet()) {
                this.rows.add(valueSet.values());
            }
        }
    }

    public QueryResponseData() {
    }

    public MetaData getMeta() {
        return this.meta;
    }

    public void setMeta(MetaData meta) {
        this.meta = meta;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<Map<String, String>> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Map<String, String>> columns) {
        this.columns = columns;
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<Object>> rows) {
        this.rows = rows;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

