/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.response.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryResultDto;

public class MetaData {
    public static final String RESULTSET = "RESULTSET";
    @JsonProperty(value="_href")
    private String href;
    @JsonProperty(value="_type")
    private String type;
    @JsonProperty(value="_schema_version")
    private String schemaVersion;
    @JsonProperty(value="_created")
    private OffsetDateTime created;
    @JsonProperty(value="_generator")
    private String generator;
    @JsonProperty(value="_executed_aql")
    private String executedAql;
    private final Map<String, Object> additionalProperties = new TreeMap<String, Object>();

    public MetaData() {
    }

    public MetaData(QueryResultDto queryResultDto) {
        this.type = RESULTSET;
        this.created = queryResultDto.getCreated();
        this.executedAql = queryResultDto.getExecutedAQL();
        this.setAdditionalProperty(AdditionalProperty.resultSize, Optional.ofNullable(queryResultDto.getResultSet()).map(List::size).orElse(0));
        Integer resultLimit = queryResultDto.getLimit();
        Integer resultOffset = queryResultDto.getOffset();
        if (resultLimit != null) {
            this.setAdditionalProperty(AdditionalProperty.fetch, resultLimit);
            this.setAdditionalProperty(AdditionalProperty.offset, resultOffset != null ? resultOffset : 0);
        }
        this.href = null;
        this.schemaVersion = null;
        this.generator = null;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public String getExecutedAql() {
        return this.executedAql;
    }

    public void setExecutedAql(String executedAql) {
        this.executedAql = executedAql;
    }

    public <T> void setAdditionalProperty(AdditionalProperty<T> property, @Nullable T value) {
        this.setAdditionalProperty(property.getName(), value);
    }

    @Nullable
    public <T> T getAdditionalProperty(AdditionalProperty<T> property) {
        Object prop = this.additionalProperties().get(property.getName());
        return prop != null ? (T)property.apply(prop) : null;
    }

    @JsonAnySetter
    private void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonAnyGetter
    private Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public static interface AdditionalProperty<T>
    extends Function<Object, T> {
        public static final IntegerProperty fetch = () -> "fetch";
        public static final IntegerProperty offset = () -> "offset";
        public static final IntegerProperty resultSize = () -> "resultsize";
        public static final BooleanProperty dryRun = () -> "_dry_run";
        public static final StringProperty executedSQL = () -> "_executed_sql";
        public static final JSONProperty queryPlan = () -> "_query_plan";

        public String getName();

        @FunctionalInterface
        public static interface IntegerProperty
        extends AdditionalProperty<Integer> {
            @Override
            default public Integer apply(Object o) {
                return o instanceof Number ? Integer.valueOf(((Number)o).intValue()) : null;
            }
        }

        @FunctionalInterface
        public static interface BooleanProperty
        extends AdditionalProperty<Boolean> {
            @Override
            default public Boolean apply(Object o) {
                return o instanceof Boolean ? (Boolean)o : null;
            }
        }

        @FunctionalInterface
        public static interface StringProperty
        extends AdditionalProperty<String> {
            @Override
            default public String apply(Object o) {
                return o instanceof String ? (String)o : null;
            }
        }

        @FunctionalInterface
        public static interface JSONProperty
        extends AdditionalProperty<Map<String, Object>> {
            @Override
            default public Map<String, Object> apply(Object o) {
                return o instanceof Map ? (Map)o : null;
            }
        }
    }
}

