/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.response.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.google.common.base.CaseFormat;
import com.nedap.archie.rm.changecontrol.VersionedObject;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import java.time.format.DateTimeFormatter;

@JacksonXmlRootElement(localName="ehr_status")
@Deprecated(since="2.14.0", forRemoval=true)
public class VersionedObjectResponseData<T> {
    @JsonProperty(value="_type")
    private String type;
    @JsonProperty
    private HierObjectId uid;
    @JsonProperty(value="owner_id")
    private ObjectRef<? extends ObjectId> ownerId;
    @JsonProperty(value="time_created")
    private String timeCreated;

    public VersionedObjectResponseData(VersionedObject<T> versionedObject) {
        String className = versionedObject.getClass().getName().replace(versionedObject.getClass().getPackage().getName() + ".", "");
        this.setType(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, className));
        this.setUid(versionedObject.getUid());
        this.setOwnerId((ObjectRef<ObjectId>)versionedObject.getOwnerId());
        this.setTimeCreated(DateTimeFormatter.ISO_DATE_TIME.format(versionedObject.getTimeCreated().getValue()));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public HierObjectId getUid() {
        return this.uid;
    }

    public void setUid(HierObjectId uid) {
        this.uid = uid;
    }

    public ObjectRef<? extends ObjectId> getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(ObjectRef<? extends ObjectId> ownerId) {
        this.ownerId = ownerId;
    }

    public String getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(String timeCreated) {
        this.timeCreated = timeCreated;
    }
}

