/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.response.dto.ehrscape;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.query.ResultHolder;

public class QueryResultDto {
    private OffsetDateTime created;
    private String executedAQL;
    private Integer limit;
    private Integer offset;
    private List<List<String>> explain;
    private Map<String, String> variables;
    private List<ResultHolder> resultSet;

    public QueryResultDto() {
        this(OffsetDateTime.now());
    }

    public QueryResultDto(OffsetDateTime created) {
        this.created = created;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public List<ResultHolder> getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(List<ResultHolder> resultSet) {
        this.resultSet = resultSet;
    }

    public String getExecutedAQL() {
        return this.executedAQL;
    }

    public void setExecutedAQL(String executedAQL) {
        this.executedAQL = executedAQL;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Nullable
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public List<List<String>> getExplain() {
        return this.explain;
    }

    public void setExplain(List<List<String>> explain) {
        this.explain = explain;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public boolean variablesIsEmpty() {
        return Optional.ofNullable(this.variables).orElse(Collections.emptyMap()).isEmpty();
    }

    public boolean variablesContainsColumnId(String columnId) {
        return this.getVariables().containsKey(columnId);
    }

    public String variablesPath(String columnId) {
        return this.getVariables().get(columnId);
    }

    public Iterator<Map.Entry<String, String>> variablesIterator() {
        return this.getVariables().entrySet().iterator();
    }
}

