/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.dto;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Id;
import org.ehrbase.openehr.sdk.generator.commons.annotations.Template;
import org.ehrbase.openehr.sdk.serialisation.dto.DefaultValuesProvider;
import org.ehrbase.openehr.sdk.serialisation.dto.DtoToCompositionWalker;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.util.exception.ClientException;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.templateprovider.TemplateProvider;
import org.ehrbase.openehr.sdk.webtemplate.webtemplateskeletonbuilder.WebTemplateSkeletonBuilder;

public class GeneratedDtoToRmConverter {
    private final TemplateProvider templateProvider;
    private final DefaultValuesProvider defaultValuesProvider;

    public GeneratedDtoToRmConverter(TemplateProvider templateProvider, DefaultValuesProvider defaultValuesProvider) {
        this.templateProvider = templateProvider;
        this.defaultValuesProvider = defaultValuesProvider;
    }

    public GeneratedDtoToRmConverter(TemplateProvider templateProvider) {
        this.defaultValuesProvider = o -> new DefaultValues();
        this.templateProvider = templateProvider;
    }

    public RMObject toRMObject(Object dto) {
        Template template = dto.getClass().getAnnotation(Template.class);
        WebTemplate introspect = (WebTemplate)this.templateProvider.buildIntrospect(template.value()).orElseThrow(() -> new SdkException(String.format("Can not find Template: %s", template.value())));
        Composition generate = WebTemplateSkeletonBuilder.build((WebTemplate)introspect, (boolean)false);
        new DtoToCompositionWalker().walk(generate, DtoToCompositionWalker.findEntity(dto), introspect, this.defaultValuesProvider.provide(dto), template.value());
        Optional<ObjectVersionId> versionUid = GeneratedDtoToRmConverter.extractVersionUid(dto);
        if (versionUid.isPresent()) {
            generate.setUid((UIDBasedId)new ObjectVersionId(versionUid.get().toString()));
        }
        return generate;
    }

    static Optional<ObjectVersionId> extractVersionUid(Object dto) {
        return Arrays.stream(dto.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(Id.class)).findAny().map(idField -> {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(idField.getName(), dto.getClass());
                return (ObjectVersionId)propertyDescriptor.getReadMethod().invoke(dto, new Object[0]);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                throw new ClientException(e.getMessage(), e);
            }
        });
    }
}

