/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import org.ehrbase.openehr.sdk.serialisation.RMDataFormat;
import org.ehrbase.openehr.sdk.serialisation.exception.MarshalException;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.FlatJasonProvider;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.marshal.FlatJsonMarshaller;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.FlatJsonUnmarshaller;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;

public class FlatJson
implements RMDataFormat {
    private final WebTemplate templateIntrospect;
    private final FlatJsonMarshaller flatJsonMarshaller;

    FlatJson(FlatJasonProvider flatJasonProvider, String templateId) {
        this.templateIntrospect = (WebTemplate)flatJasonProvider.getTemplateProvider().buildIntrospect(templateId).orElseThrow(() -> new SdkException(String.format("Template %s not found", templateId)));
        this.flatJsonMarshaller = new FlatJsonMarshaller();
    }

    @Override
    public String marshal(RMObject rmObject) {
        if (rmObject instanceof Composition) {
            return this.flatJsonMarshaller.toFlatJson((Composition)rmObject, this.templateIntrospect);
        }
        throw new MarshalException(String.format("Class %s not supported in flat format", rmObject.getClass().getSimpleName()));
    }

    @Override
    public <T extends RMObject> T unmarshal(String value, Class<T> clazz) {
        if (clazz.isAssignableFrom(Composition.class)) {
            return (T)this.unmarshal(value);
        }
        throw new SdkException(String.format("Class %s not supported in flat format", clazz.getSimpleName()));
    }

    @Override
    public Composition unmarshal(String value) {
        return new FlatJsonUnmarshaller().unmarshal(value, this.templateIntrospect);
    }
}

