/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.rm.composition.Composition;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.Language;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.Setting;
import org.ehrbase.openehr.sdk.serialisation.exception.UnmarshalException;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.StdToCompositionWalker;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;
import org.ehrbase.openehr.sdk.webtemplate.webtemplateskeletonbuilder.WebTemplateSkeletonBuilder;

public class FlatJsonUnmarshaller {
    private static final ObjectMapper OBJECT_MAPPER = ArchieObjectMapperProvider.getObjectMapper();

    public Composition unmarshal(String flat, WebTemplate introspect) {
        HashSet<String> consumedPath = new HashSet();
        try {
            HashMap<String, String> currentValues = new HashMap<String, String>();
            Iterator it = OBJECT_MAPPER.readTree(flat).fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                currentValues.put((String)e.getKey(), ((JsonNode)e.getValue()).toString());
            }
            Composition generate = WebTemplateSkeletonBuilder.build((WebTemplate)introspect, (boolean)false);
            StdToCompositionWalker walker = new StdToCompositionWalker();
            DefaultValues defaultValues = new DefaultValues(currentValues);
            if (!defaultValues.containsDefaultValue(DefaultValuePath.LANGUAGE)) {
                defaultValues.addDefaultValue(DefaultValuePath.LANGUAGE, FlatHelper.findEnumValueOrThrow(introspect.getDefaultLanguage(), Language.class));
            }
            if (!defaultValues.containsDefaultValue(DefaultValuePath.TIME)) {
                defaultValues.addDefaultValue(DefaultValuePath.TIME, OffsetDateTime.now());
            }
            if (!defaultValues.containsDefaultValue(DefaultValuePath.SETTING)) {
                defaultValues.addDefaultValue(DefaultValuePath.SETTING, Setting.OTHER_CARE);
            }
            String templateId = generate.getArchetypeDetails().getTemplateId().getValue();
            walker.walk(generate, currentValues.entrySet().stream().collect(Collectors.toMap(e1 -> new FlatPathDto((CharSequence)e1.getKey()), Map.Entry::getValue)), introspect, defaultValues, templateId);
            consumedPath = walker.getConsumedPaths();
            if (!CollectionUtils.isEmpty(FlatJsonUnmarshaller.getUnconsumed(consumedPath, currentValues))) {
                throw new UnmarshalException(String.format("Could not consume Parts %s", FlatJsonUnmarshaller.getUnconsumed(consumedPath, currentValues)));
            }
            return generate;
        }
        catch (JsonProcessingException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof DateTimeException) {
                throw new UnmarshalException(e.getMessage(), e);
            }
            throw e;
        }
    }

    private static Set<String> getUnconsumed(Set<String> consumedPath, Map<String, String> currentValues) {
        if (currentValues != null && consumedPath != null) {
            HashSet<String> set = new HashSet<String>(currentValues.keySet());
            set.removeAll(consumedPath);
            return set.stream().filter(p -> !p.startsWith("ctx")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

