/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.generic.PartySelf;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.serialisation.exception.UnmarshalException;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.StdToCompositionWalker;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.UnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public abstract class AbstractUnmarshalPostprocessor<T extends RMObject>
implements UnmarshalPostprocessor<T> {
    private static final ObjectMapper OBJECT_MAPPER = ArchieObjectMapperProvider.getObjectMapper();

    protected <S> void setValue(String term, String propertyName, Map<FlatPathDto, String> values, Consumer<S> consumer, Class<S> clazz, Set<String> consumedPaths) {
        Object key = propertyName != null ? term + "|" + propertyName : term;
        Map.Entry entry = FlatPathDto.get(values, (String)key);
        String jasonValue = (String)entry.getValue();
        if (StringUtils.isNotBlank((CharSequence)jasonValue)) {
            try {
                Object value = OBJECT_MAPPER.readValue(jasonValue, clazz);
                consumer.accept(value);
                consumedPaths.add(((FlatPathDto)entry.getKey()).format());
            }
            catch (JsonProcessingException e) {
                throw new SdkException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void handleRmAttribute(String currentTerm, RMObject rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context, String attributeId) {
        this.callUnmarshal(currentTerm, "_" + attributeId, rmObject, values, consumedPaths, context, context.getNodeDeque().peek().findChildById(attributeId).orElse(FlatHelper.buildDummyChild(attributeId, context.getNodeDeque().peek())));
        this.callPostProcess(currentTerm, "_" + attributeId, rmObject, values, consumedPaths, context, context.getNodeDeque().peek().findChildById(attributeId).orElse(FlatHelper.buildDummyChild(attributeId, context.getNodeDeque().peek())));
    }

    protected void callUnmarshal(String term, String subTerm, RMObject rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context, WebTemplateNode subNode) {
        String newTerm;
        Map<FlatPathDto, String> subValues;
        if (subNode != null) {
            context.getNodeDeque().push(subNode);
        }
        if (!(subValues = FlatHelper.filter(values, newTerm = term + "/" + subTerm, false)).isEmpty()) {
            StdToCompositionWalker.findRMUnmarshaller(rmObject.getClass()).handle(newTerm, rmObject, subValues, context, consumedPaths);
        }
        if (subNode != null) {
            context.getNodeDeque().poll();
        }
    }

    protected void callPostProcess(String term, String subTerm, RMObject rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context, WebTemplateNode subNode) {
        Object newTerm;
        Map<FlatPathDto, String> subValues;
        if (subNode != null) {
            context.getNodeDeque().push(subNode);
        }
        if (!(subValues = FlatHelper.filter(values, (String)(newTerm = subTerm != null ? term + "/" + subTerm : term), false)).isEmpty()) {
            StdToCompositionWalker.findUnmarshalPostprocessors(rmObject.getClass()).forEach(arg_0 -> AbstractUnmarshalPostprocessor.lambda$callPostProcess$0((String)newTerm, rmObject, subValues, consumedPaths, context, arg_0));
        }
        if (subNode != null) {
            context.getNodeDeque().poll();
        }
    }

    protected void setParty(String currentTerm, Consumer<PartyProxy> partyConsumer, Map<FlatPathDto, String> currentValues, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context, String id, boolean allowPartySelf) {
        Map<FlatPathDto, String> values = FlatHelper.filter(currentValues, currentTerm + "/" + id, false);
        if (!values.isEmpty()) {
            PartyRelated partyProxy;
            if (FlatHelper.isExactlyPartyRelated(values, currentTerm + "/" + id, null)) {
                partyProxy = new PartyRelated();
            } else if (FlatHelper.isExactlyPartyIdentified(values, currentTerm + "/" + id, null)) {
                partyProxy = new PartyIdentified();
            } else if (allowPartySelf && FlatHelper.isExactlyPartySelf(values, currentTerm + "/" + id, null)) {
                partyProxy = new PartySelf();
            } else {
                throw new UnmarshalException(String.format("Could not find concrete instance of Party proxy for %s/%s", currentTerm, id));
            }
            partyConsumer.accept((PartyProxy)partyProxy);
            this.callUnmarshal(currentTerm, id, (RMObject)partyProxy, values, consumedPaths, context, FlatHelper.findOrBuildSubNode(context, StringUtils.removeStart((String)id, (String)"_")));
            this.callPostProcess(currentTerm, id, (RMObject)partyProxy, values, consumedPaths, context, FlatHelper.findOrBuildSubNode(context, id));
        }
    }

    private static /* synthetic */ void lambda$callPostProcess$0(String newTerm, RMObject rmObject, Map subValues, Set consumedPaths, Context context, UnmarshalPostprocessor p) {
        p.process(newTerm, rmObject, subValues, consumedPaths, context);
    }
}

