/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class EventContextUnmarshalPostprocessor
extends AbstractUnmarshalPostprocessor<EventContext> {
    @Override
    public void process(String term, EventContext rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        this.setValue(term + "/_location", null, values, arg_0 -> ((EventContext)rmObject).setLocation(arg_0), String.class, consumedPaths);
        this.setValue(term + "/_end_time", null, values, s -> {
            if (s != null) {
                rmObject.setEndTime(new DvDateTime(s));
            }
        }, String.class, consumedPaths);
        this.setParty(term, p -> rmObject.setHealthCareFacility((PartyIdentified)p), values, consumedPaths, context, "_health_care_facility", false);
        Map<Integer, Map<FlatPathDto, String>> other = FlatHelper.extractMultiValued(term, "_participation", values);
        other.replaceAll((k, v) -> FlatHelper.convertAttributeToFlat(v, term + "/_participation:" + k, "identifiers", "_identifier"));
        rmObject.getParticipations().addAll(other.entrySet().stream().map(e -> DefaultValues.buildParticipation((Map)e.getValue(), term + "/_participation:" + String.valueOf(e.getKey()))).collect(Collectors.toList()));
        FlatHelper.consumeAllMatching(term + "/_participation", values, consumedPaths, false);
        consumedPaths.add(term + "/setting|238");
        consumedPaths.add(term + "/setting|");
        if (rmObject.getSetting() != null && (rmObject.getSetting().getDefiningCode().getTerminologyId() == null || rmObject.getSetting().getDefiningCode().getTerminologyId().getValue() == null)) {
            rmObject.getSetting().getDefiningCode().setTerminologyId(new TerminologyId("openehr"));
        }
    }

    public Class<EventContext> getAssociatedClass() {
        return EventContext.class;
    }
}

