/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class LocatableUnmarshalPostprocessor
extends AbstractUnmarshalPostprocessor<Locatable> {
    @Override
    public void process(String term, Locatable rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        String rmType = Optional.ofNullable(context.getNodeDeque().peek()).map(WebTemplateNode::getRmType).orElse(null);
        if ("ELEMENT".equals(rmType) || !context.getFlatHelper().skip(context)) {
            this.setUID(term, rmObject, values, consumedPaths);
            this.setName(term, rmObject, values, consumedPaths, context);
            this.setLinks(term, rmObject, values, consumedPaths);
            this.setFeederAudit(term, rmObject, values, consumedPaths, context);
        }
    }

    public Class<Locatable> getAssociatedClass() {
        return Locatable.class;
    }

    private void setUID(String term, Locatable rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths) {
        this.setValue(term + "/_uid", null, values, value -> rmObject.setUid((UIDBasedId)(StringUtils.countMatches((CharSequence)value, (CharSequence)"::") == 2 ? new ObjectVersionId(value) : new HierObjectId(value))), String.class, consumedPaths);
    }

    private void setName(String term, Locatable rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        Map<FlatPathDto, String> nameValues = FlatHelper.filter(values, term + "/_name", false);
        if (!nameValues.isEmpty()) {
            boolean isDvCodedText = nameValues.keySet().stream().anyMatch(e -> {
                FlatPathDto last = e.getLast();
                return "code".equals(last.getAttributeName()) && "_name".equals(last.getName());
            });
            rmObject.setName((DvText)(isDvCodedText ? new DvCodedText() : new DvText()));
            this.handleRmAttribute(term, (RMObject)rmObject.getName(), nameValues, consumedPaths, context, "name");
        }
    }

    private void setLinks(String term, Locatable rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths) {
        Map<Integer, Map<FlatPathDto, String>> links = FlatHelper.extractMultiValued(term, "_link", values);
        if (rmObject.getLinks() == null) {
            rmObject.setLinks(new ArrayList());
        }
        rmObject.getLinks().addAll(links.entrySet().stream().map(e -> DefaultValues.createLink((Map)e.getValue(), term + "/_link:" + String.valueOf(e.getKey()))).toList());
        FlatHelper.consumeAllMatching(term + "/_link", values, consumedPaths, false);
    }

    private void setFeederAudit(String term, Locatable rmObject, Map<FlatPathDto, String> values, Set<String> consumedPaths, Context<Map<FlatPathDto, String>> context) {
        Map<FlatPathDto, String> feederAuditValues = FlatHelper.filter(values, term + "/_feeder_audit", false);
        if (!feederAuditValues.isEmpty()) {
            rmObject.setFeederAudit(new FeederAudit());
            this.handleRmAttribute(term, (RMObject)rmObject.getFeederAudit(), feederAuditValues, consumedPaths, context, "feeder_audit");
        }
    }
}

