/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.rm.RMObject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.serialisation.flatencoding.std.umarshal.rmunmarshaller.RMUnmarshaller;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.util.reflection.ReflectionHelper;
import org.ehrbase.openehr.sdk.webtemplate.parser.config.RmIntrospectConfig;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public abstract class AbstractRMUnmarshaller<T extends RMObject>
implements RMUnmarshaller<T> {
    private static final ObjectMapper OBJECT_MAPPER = ArchieObjectMapperProvider.getObjectMapper();
    private static final Map<Class<?>, RmIntrospectConfig> configMap = ReflectionHelper.buildMap(RmIntrospectConfig.class);

    @Override
    public void handle(String currentTerm, T rmObject, Map<FlatPathDto, String> currentValues, Context<Map<FlatPathDto, String>> context, Set<String> consumedPaths) {
        Set expandFields = Optional.ofNullable(configMap.get(rmObject.getClass())).map(RmIntrospectConfig::getNonTemplateFields).orElse(Collections.emptySet());
        if (!expandFields.isEmpty()) {
            if (expandFields.size() == 1 && expandFields.contains("value")) {
                try {
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor("value", rmObject.getClass());
                    this.setValue(currentTerm, null, currentValues, s -> {
                        try {
                            propertyDescriptor.getWriteMethod().invoke(rmObject, s);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new SdkException(e.getMessage(), (Throwable)e);
                        }
                    }, propertyDescriptor.getPropertyType(), consumedPaths);
                }
                catch (IntrospectionException e) {
                    throw new SdkException(e.getMessage(), (Throwable)e);
                }
            } else {
                for (String propertyName : expandFields) {
                    try {
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, rmObject.getClass());
                        this.setValue(currentTerm, propertyName, currentValues, s -> {
                            try {
                                propertyDescriptor.getWriteMethod().invoke(rmObject, s);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new SdkException(e.getMessage(), (Throwable)e);
                            }
                        }, propertyDescriptor.getPropertyType(), consumedPaths);
                    }
                    catch (IntrospectionException e) {
                        throw new SdkException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected <S> void setValue(String term, String propertyName, Map<FlatPathDto, String> values, Consumer<S> consumer, Class<S> clazz, Set<String> consumedPaths) {
        Object key = propertyName != null ? term + "|" + propertyName : term;
        Map.Entry entry = FlatPathDto.get(values, (String)key);
        String jasonValue = (String)entry.getValue();
        if (StringUtils.isNotBlank((CharSequence)jasonValue)) {
            try {
                Object value = OBJECT_MAPPER.readValue(jasonValue, clazz);
                consumer.accept(value);
                consumedPaths.add(((FlatPathDto)entry.getKey()).format());
            }
            catch (JsonProcessingException e) {
                throw new SdkException(e.getMessage(), (Throwable)e);
            }
        } else {
            consumer.accept(null);
        }
    }
}

