/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.flatencoding.structured;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class StructuredHelper {
    private static final ObjectMapper OBJECT_MAPPER = ArchieObjectMapperProvider.getObjectMapper();

    private StructuredHelper() {
    }

    public static String convertStructuredToFlat(String structuredString) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(structuredString);
            Map<String, JsonNode> convert = StructuredHelper.convertStructuredToFlat("", jsonNode);
            return OBJECT_MAPPER.writeValueAsString(convert);
        }
        catch (JsonProcessingException e) {
            throw new SdkException(e.getMessage(), (Throwable)e);
        }
    }

    public static String convertFlatToStructured(String flatString) {
        try {
            JsonNode jsonNode = null;
            jsonNode = OBJECT_MAPPER.readTree(flatString);
            LinkedHashMap<FlatPathDto, JsonNode> flatMap = new LinkedHashMap<FlatPathDto, JsonNode>();
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry next = (Map.Entry)it.next();
                flatMap.put(new FlatPathDto((CharSequence)next.getKey()), (JsonNode)next.getValue());
            }
            Map<String, Object> structuredMap = StructuredHelper.convertFlatToStructured(flatMap);
            Map.Entry root = (Map.Entry)structuredMap.entrySet().stream().findAny().orElseThrow();
            structuredMap.replace((String)root.getKey(), ((List)root.getValue()).get(0));
            return OBJECT_MAPPER.writeValueAsString(structuredMap);
        }
        catch (JsonProcessingException e) {
            throw new SdkException(e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, Object> convertFlatToStructured(Map<FlatPathDto, JsonNode> flatMap) {
        Map sharedStartMap = flatMap.entrySet().stream().collect(Collectors.groupingBy(e -> {
            FlatPathDto startFlatPathDto = new FlatPathDto(((FlatPathDto)e.getKey()).getName(), null, ((FlatPathDto)e.getKey()).getCount(), null);
            return startFlatPathDto;
        }, LinkedHashMap::new, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, LinkedHashMap::new)));
        LinkedHashMap<String, Object> structured = new LinkedHashMap<String, Object>();
        sharedStartMap.forEach((k, v) -> {
            Map<String, Object> subMap = StructuredHelper.convertFlatToStructured(v.entrySet().stream().filter(e -> ((FlatPathDto)e.getKey()).getChild() != null).collect(Collectors.toMap(e -> FlatPathDto.removeStart((FlatPathDto)((FlatPathDto)e.getKey()), (FlatPathDto)k), Map.Entry::getValue, (u, t) -> u, LinkedHashMap::new)));
            Map attributes = v.entrySet().stream().filter(e -> ((FlatPathDto)e.getKey()).getChild() == null).collect(Collectors.toMap(e -> Optional.ofNullable(((FlatPathDto)e.getKey()).getAttributeName()).map(s -> "|" + s).orElse(""), Map.Entry::getValue, (u, j) -> u, LinkedHashMap::new));
            List values = (List)structured.computeIfAbsent(k.getName(), n -> new ArrayList());
            if (attributes.size() == 1 && attributes.containsKey("") && subMap.isEmpty()) {
                values.add(attributes.values().stream().findAny().orElse(""));
            } else {
                if (attributes.containsKey("")) {
                    subMap.put("|value", attributes.get(""));
                    attributes.remove("");
                }
                subMap.putAll(attributes);
            }
            if (!subMap.isEmpty()) {
                values.add(subMap);
            }
        });
        return structured;
    }

    private static Map<String, JsonNode> convertStructuredToFlat(String path, JsonNode jsonNode) {
        if (jsonNode instanceof ValueNode) {
            return Map.of(path, jsonNode);
        }
        if (jsonNode instanceof ObjectNode) {
            HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry field = (Map.Entry)it.next();
                Object newPath = StringUtils.startsWith((CharSequence)((CharSequence)field.getKey()), (CharSequence)"|") || StringUtils.isBlank((CharSequence)path) ? path + (String)field.getKey() : (StringUtils.isEmpty((CharSequence)((CharSequence)field.getKey())) ? path : path + "/" + (String)field.getKey());
                map.putAll(StructuredHelper.convertStructuredToFlat((String)newPath, (JsonNode)field.getValue()));
            }
            return map;
        }
        if (jsonNode instanceof ArrayNode) {
            LinkedHashMap<String, JsonNode> map = new LinkedHashMap<String, JsonNode>();
            boolean needsIndex = IntStream.range(0, jsonNode.size()).mapToObj(arg_0 -> ((JsonNode)jsonNode).get(arg_0)).map(n -> {
                if (n instanceof ObjectNode) {
                    return StreamSupport.stream(Spliterators.spliteratorUnknownSize(n.fields(), 16), false).map(Map.Entry::getKey).anyMatch(s -> !StringUtils.startsWith((CharSequence)s, (CharSequence)"_"));
                }
                return true;
            }).filter(BooleanUtils::isTrue).count() > 1L;
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode child = jsonNode.get(i);
                Object newPath = i > 0 && needsIndex ? path + ":" + i : path;
                map.putAll(StructuredHelper.convertStructuredToFlat((String)newPath, child));
            }
            return map;
        }
        throw new SdkException(String.format("Unknown Structure %s", jsonNode.getClass().getSimpleName()));
    }
}

