/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.jsonencoding;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rminfo.ArchieAOMInfoLookup;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ehrbase.openehr.sdk.serialisation.RMDataFormat;
import org.ehrbase.openehr.sdk.serialisation.exception.MarshalException;
import org.ehrbase.openehr.sdk.serialisation.exception.UnmarshalException;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.Base64Deserializer;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.Base64Serializer;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.DateDeserializer;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.DateSerializer;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.DateTimeDeserializer;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.DateTimeSerializer;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.TimeDeserializer;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.TimeSerializer;

public class CanonicalJson
implements RMDataFormat {
    public static final ObjectMapper MARSHAL_OM = ArchieObjectMapperProvider.getObjectMapper().copy();

    @Override
    public String marshal(RMObject rmObject) {
        StringWriter stringWriter = new StringWriter();
        try {
            MARSHAL_OM.writeValue((Writer)stringWriter, (Object)rmObject);
        }
        catch (IOException e) {
            throw new MarshalException(e.getMessage(), e);
        }
        return stringWriter.toString();
    }

    @Override
    public <T extends RMObject> T unmarshal(String value, Class<T> clazz) {
        try {
            return (T)((RMObject)MARSHAL_OM.readValue(value, clazz));
        }
        catch (IOException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    public Map<String, Object> unmarshalToMap(String value) {
        try {
            return (Map)MARSHAL_OM.readValue(value, Map.class);
        }
        catch (IOException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    static {
        MARSHAL_OM.addMixIn(ArchetypeID.class, ObjectIdMixIn.class).addMixIn(Locatable.class, LocatableMixIn.class).addMixIn(Pathable.class, PathableMixIn.class).addMixIn(UIDBasedId.class, UIDBasedIdMixIn.class);
        SimpleModule module = new SimpleModule();
        module.addSerializer(DvDateTime.class, (JsonSerializer)new DateTimeSerializer());
        module.addSerializer(DvTime.class, (JsonSerializer)new TimeSerializer());
        module.addSerializer(DvDate.class, (JsonSerializer)new DateSerializer());
        module.addSerializer(byte[].class, (JsonSerializer)new Base64Serializer());
        module.addDeserializer(DvDateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        module.addDeserializer(DvTime.class, (JsonDeserializer)new TimeDeserializer());
        module.addDeserializer(DvDate.class, (JsonDeserializer)new DateDeserializer());
        module.addDeserializer(byte[].class, (JsonDeserializer)new Base64Deserializer());
        MARSHAL_OM.registerModule((Module)module);
        MARSHAL_OM.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.CUSTOM, (JsonInclude.Include)JsonInclude.Include.CUSTOM, ExcludeEmptyCollectionsFilter.class, ExcludeEmptyCollectionsFilter.class));
        StdTypeResolverBuilder typeResolverBuilder = new CJArchieTypeResolverBuilder().init(JsonTypeInfo.Id.NAME, (TypeIdResolver)new CJOpenEHRTypeNaming()).typeProperty("_type").typeIdVisibility(true).inclusion(JsonTypeInfo.As.PROPERTY);
        MARSHAL_OM.setDefaultTyping((TypeResolverBuilder)typeResolverBuilder);
    }

    abstract class ObjectIdMixIn {
        ObjectIdMixIn(String value) {
        }

        @JsonProperty(value="value")
        abstract String getValue();

        @JsonIgnore
        abstract String getFullId();

        @JsonIgnore
        abstract String getSemanticId();

        @JsonIgnore
        abstract String getQualifiedRmEntity();

        @JsonIgnore
        abstract String getDomainConcept();

        @JsonIgnore
        abstract String getRmOriginator();

        @JsonIgnore
        abstract String getRmName();

        @JsonIgnore
        abstract String getRmEntity();

        @JsonIgnore
        abstract String getSpecialisation();

        @JsonIgnore
        abstract String getVersionId();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract class LocatableMixIn {
        LocatableMixIn(@JsonProperty UIDBasedId uid, @JsonProperty String archetypeNodeId, List<Link> links) {
        }

        @JsonProperty(value="archetype_node_id")
        abstract String getArchetypeNodeId();

        @JsonProperty(value="uid")
        abstract UIDBasedId getUid();

        @JsonProperty(value="links")
        abstract List<Link> getLinks();
    }

    abstract class PathableMixIn {
        PathableMixIn() {
        }

        @JsonIgnore
        abstract String getPath();

        @JsonIgnore
        abstract List<PathSegment> getPathSegments();
    }

    abstract class UIDBasedIdMixIn {
        UIDBasedIdMixIn(String value) {
        }

        @JsonProperty(value="value")
        abstract String getValue();

        @JsonIgnore
        abstract String getRoot();

        @JsonIgnore
        abstract String getExtension();
    }

    private static class ExcludeEmptyCollectionsFilter {
        private ExcludeEmptyCollectionsFilter() {
        }

        public boolean equals(Object o) {
            if (o == null) {
                return true;
            }
            if (o instanceof Map) {
                return ((Map)o).size() == 0;
            }
            if (o instanceof Collection) {
                return ((Collection)o).isEmpty();
            }
            if (o instanceof Object[]) {
                return ((Object[])o).length == 0;
            }
            return false;
        }
    }

    static class CJArchieTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        public CJArchieTypeResolverBuilder() {
            super(ObjectMapper.DefaultTyping.NON_FINAL);
        }

        public boolean useForType(JavaType t) {
            return OpenEHRBase.class.isAssignableFrom(t.getRawClass()) && !ArchetypeID.class.equals((Object)t.getRawClass()) && !TemplateId.class.equals((Object)t.getRawClass()) && !Archetyped.class.equals((Object)t.getRawClass()) && !Link.class.equals((Object)t.getRawClass()) && !History.class.equals((Object)t.getRawClass());
        }
    }

    public static class CJOpenEHRTypeNaming
    extends ClassNameIdResolver {
        private ModelInfoLookup rmInfoLookup = ArchieRMInfoLookup.getInstance();
        private ModelInfoLookup aomInfoLookup = ArchieAOMInfoLookup.getInstance();

        public CJOpenEHRTypeNaming() {
            super(TypeFactory.defaultInstance().constructType(OpenEHRBase.class), TypeFactory.defaultInstance());
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.NAME;
        }

        public String idFromValue(Object value) {
            RMTypeInfo typeInfo = this.rmInfoLookup.getTypeInfo(value.getClass());
            if (typeInfo == null) {
                typeInfo = this.aomInfoLookup.getTypeInfo(value.getClass());
            }
            if (typeInfo != null) {
                return typeInfo.getRmName();
            }
            return this.rmInfoLookup.getNamingStrategy().getTypeName(value.getClass());
        }

        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            return this._typeFromId(id, context);
        }

        protected JavaType _typeFromId(String typeName, DatabindContext ctxt) throws IOException {
            Class result = this.rmInfoLookup.getClass(typeName);
            if (result == null) {
                result = this.aomInfoLookup.getClass(typeName);
            }
            if (result != null) {
                TypeFactory typeFactory = ctxt == null ? this._typeFactory : ctxt.getTypeFactory();
                return typeFactory.constructSpecializedType(this._baseType, result);
            }
            return super._typeFromId(typeName, ctxt);
        }
    }
}

