/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateComparisonSymbol;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInterval;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateValidation;
import org.threeten.extra.PeriodDuration;

public class DurationHelper {
    private DurationHelper() {
    }

    public static Optional<TemporalAmount> buildTotalRange(WebTemplateNode node, MIN_MAX minMax) {
        return Optional.ofNullable(node).map(WebTemplateNode::getInputs).stream().flatMap(Collection::stream).flatMap(input -> Optional.of(input).map(WebTemplateInput::getValidation).map(WebTemplateValidation::getRange).map(r -> minMax.getValue(r)).filter(Integer.class::isInstance).map(value -> DurationHelper.build(input, (Integer)value)).stream()).reduce((a, b) -> PeriodDuration.from((TemporalAmount)a).plus(b));
    }

    public static WebTemplateComparisonSymbol getTotalComparisonSymbol(WebTemplateNode node, MIN_MAX minMax) {
        Iterator symbols = Optional.ofNullable(node).map(WebTemplateNode::getInputs).stream().flatMap(Collection::stream).map(WebTemplateInput::getValidation).filter(Objects::nonNull).map(WebTemplateValidation::getRange).filter(Objects::nonNull).map(minMax::getOp).filter(Objects::nonNull).iterator();
        if (!symbols.hasNext()) {
            return null;
        }
        WebTemplateComparisonSymbol first = (WebTemplateComparisonSymbol)symbols.next();
        if (first == WebTemplateComparisonSymbol.GT || first == WebTemplateComparisonSymbol.LT) {
            return first;
        }
        while (symbols.hasNext()) {
            WebTemplateComparisonSymbol next = (WebTemplateComparisonSymbol)symbols.next();
            if (next != WebTemplateComparisonSymbol.GT && next != WebTemplateComparisonSymbol.LT) continue;
            return next;
        }
        return first;
    }

    private static TemporalAmount build(WebTemplateInput input, Integer integer) {
        return switch (input.getSuffix()) {
            case "year" -> Period.ofYears(integer);
            case "month" -> Period.ofMonths(integer);
            case "day" -> Period.ofDays(integer);
            case "week" -> Period.ofWeeks(integer);
            case "hour" -> Duration.ofHours(integer.intValue());
            case "minute" -> Duration.ofMinutes(integer.intValue());
            case "second" -> Duration.ofSeconds(integer.intValue());
            default -> throw new IllegalArgumentException("Unsupported suffix: " + input.getSuffix());
        };
    }

    public static enum MIN_MAX {
        MIN(WebTemplateInterval::getMin, WebTemplateInterval::getMinOp),
        MAX(WebTemplateInterval::getMax, WebTemplateInterval::getMaxOp);

        private final Function<WebTemplateInterval, Serializable> valueFunc;
        private final Function<WebTemplateInterval, WebTemplateComparisonSymbol> opFunc;

        private MIN_MAX(Function<WebTemplateInterval, Serializable> valueFunc, Function<WebTemplateInterval, WebTemplateComparisonSymbol> opFunc) {
            this.valueFunc = valueFunc;
            this.opFunc = opFunc;
        }

        public <T extends Serializable> T getValue(WebTemplateInterval<T> v) {
            return (T)this.valueFunc.apply(v);
        }

        public WebTemplateComparisonSymbol getOp(WebTemplateInterval v) {
            return this.opFunc.apply(v);
        }
    }
}

