/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.generator.commons.interfaces.EnumValueSet;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.NodeId;
import org.ehrbase.openehr.sdk.serialisation.walker.Walker;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;
import org.ehrbase.openehr.sdk.webtemplate.parser.OPTParser;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathParser;

public class FlatHelper<T> {
    private final Map<String, Map<List<String>, Integer>> pathCountMap = new HashMap<String, Map<List<String>, Integer>>();

    public String buildNamePath(Context<T> context, boolean addCount) {
        StringBuilder namePathBuilder = new StringBuilder();
        ArrayList<String> nodeIdPath = new ArrayList<String>();
        WebTemplateNode child = null;
        Iterator<WebTemplateNode> iterator = context.getNodeDeque().descendingIterator();
        while (iterator.hasNext()) {
            WebTemplateNode parent = child;
            child = iterator.next();
            boolean skip = this.skip(child, parent);
            boolean parentIsSkippedElement = parent != null && "ELEMENT".equals(parent.getRmType()) && this.skip(parent, null);
            WebTemplateNode node = parentIsSkippedElement ? parent : child;
            nodeIdPath.add(node.getId(true));
            if (skip) continue;
            if (!namePathBuilder.isEmpty()) {
                namePathBuilder.append('/');
            }
            namePathBuilder.append(node.getId(false));
            String key = namePathBuilder.toString();
            Map pathCounts = this.pathCountMap.computeIfAbsent(key, l -> new HashMap());
            List nodeIdPathKey = List.copyOf(nodeIdPath);
            int pathCount = pathCounts.computeIfAbsent(nodeIdPathKey, k -> 1 + FlatHelper.maxValue(pathCounts));
            if (pathCount != 1) {
                namePathBuilder.append(pathCount);
            }
            FlatHelper.appendCount(node, context, addCount, namePathBuilder);
            Map map = this.pathCountMap.computeIfAbsent(namePathBuilder.toString(), l -> new HashMap());
            map.computeIfAbsent(nodeIdPath, k -> 1 + FlatHelper.maxValue(map));
        }
        return namePathBuilder.toString();
    }

    private static int maxValue(Map<?, Integer> map) {
        return map.values().stream().mapToInt(Integer::intValue).max().orElse(0);
    }

    private static void appendCount(WebTemplateNode node, Context<?> context, boolean forceAppend, StringBuilder sb) {
        if (node.getMax() == 1) {
            return;
        }
        Optional.of(node).map(NodeId::new).map(context.getCountMap()::get).filter(c -> forceAppend || c != 0).ifPresent(c -> sb.append(":").append(c));
    }

    public static boolean isExactlyDvCodedText(Map<FlatPathDto, String> values, String path) {
        FlatPathDto codeAtt = FlatPathParser.parse((CharSequence)path).pathWithAttributeName("code");
        return values.keySet().stream().anyMatch(e -> e.isEqualTo(codeAtt));
    }

    public static boolean isExactlyPartySelf(Map<FlatPathDto, String> values, String path, WebTemplateNode node) {
        if (node != null && !FlatHelper.rmTypeMatches(node, "RM_OBJECT", "PARTY_PROXY", "PARTY_SELF")) {
            return false;
        }
        FlatPathDto pathDto = FlatPathParser.parse((CharSequence)path);
        FlatPathDto typePath = pathDto.pathWithAttributeName("_type");
        FlatPathDto namePath = pathDto.pathWithAttributeName("name");
        FlatPathDto idPath = pathDto.pathWithAttributeName("id");
        FlatPathDto relationshipPath = pathDto.pathWithChild(FlatPathParser.parse((CharSequence)"relationship"));
        FlatPathDto identifierPath = pathDto.pathWithChild(FlatPathParser.parse((CharSequence)"_identifier"));
        Iterator valueIt = FlatHelper.subEntries(values, path).iterator();
        boolean hasAttributeFromDifferentType = false;
        while (valueIt.hasNext()) {
            Map.Entry e = (Map.Entry)valueIt.next();
            if (FlatHelper.keyAndValueMatches(e, typePath, "PARTY_SELF")) {
                return true;
            }
            FlatPathDto key = (FlatPathDto)e.getKey();
            if (hasAttributeFromDifferentType) continue;
            hasAttributeFromDifferentType = key.isEqualTo(namePath) || key.isEqualTo(idPath) || key.startsWith(relationshipPath) || key.startsWith(identifierPath);
        }
        return !hasAttributeFromDifferentType;
    }

    public static boolean isExactlyPartyRelated(Map<FlatPathDto, String> values, String path, WebTemplateNode node) {
        if (node != null && !FlatHelper.rmTypeMatches(node, "RM_OBJECT", "PARTY_PROXY", "PARTY_IDENTIFIED", "PARTY_RELATED")) {
            return false;
        }
        FlatPathDto pathDto = FlatPathParser.parse((CharSequence)path);
        FlatPathDto relationshipPath = pathDto.pathWithChild(FlatPathParser.parse((CharSequence)"relationship"));
        return FlatHelper.subEntries(values, path).anyMatch(e -> ((FlatPathDto)e.getKey()).startsWith(relationshipPath));
    }

    public static boolean isExactlyPartyIdentified(Map<FlatPathDto, String> values, String path, WebTemplateNode node) {
        if (node != null && !FlatHelper.rmTypeMatches(node, "RM_OBJECT", "PARTY_PROXY", "PARTY_IDENTIFIED")) {
            return false;
        }
        FlatPathDto pathDto = FlatPathParser.parse((CharSequence)path);
        FlatPathDto typePath = pathDto.pathWithAttributeName("_type");
        FlatPathDto relationshipPath = pathDto.pathWithChild(new FlatPathDto("relationship", null, null, null));
        FlatPathDto namePath = pathDto.pathWithAttributeName("name");
        FlatPathDto idPath = pathDto.pathWithAttributeName("id");
        FlatPathDto identifierPath = pathDto.pathWithChild(new FlatPathDto("_identifier", null, null, null));
        Iterator valueIt = FlatHelper.subEntries(values, path).iterator();
        boolean hasAttributeFromType = false;
        while (valueIt.hasNext()) {
            Map.Entry e = (Map.Entry)valueIt.next();
            FlatPathDto key = (FlatPathDto)e.getKey();
            if (FlatHelper.keyAndValueMatches(e, typePath, "PARTY_SELF") || key.startsWith(relationshipPath)) {
                return false;
            }
            if (hasAttributeFromType) continue;
            hasAttributeFromType = key.isEqualTo(namePath) || key.isEqualTo(idPath) || key.startsWith(identifierPath);
        }
        return hasAttributeFromType;
    }

    private static Stream<Map.Entry<FlatPathDto, String>> subEntries(Map<FlatPathDto, String> values, String path) {
        return values.entrySet().stream().filter(e -> ((FlatPathDto)e.getKey()).startsWith((CharSequence)path));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean keyAndValueMatches(Map.Entry<FlatPathDto, String> entry, FlatPathDto typePath, String value) {
        if (!entry.getKey().isEqualTo(typePath)) return false;
        if (!Optional.of(entry).map(Map.Entry::getValue).map(v -> StringUtils.unwrap((String)v, (char)'\"')).filter(value::equals).isPresent()) return false;
        return true;
    }

    private static boolean rmTypeMatches(WebTemplateNode node, String ... rmTypNames) {
        return ArrayUtils.contains((Object[])rmTypNames, (Object)node.getRmType());
    }

    public static boolean isExactlyIntervalEvent(Map<FlatPathDto, String> values, String path) {
        FlatPathDto mathFunctionPath = FlatPathParser.parse((CharSequence)path).pathWithChild(new FlatPathDto("math_function", null, null, null));
        return values.keySet().stream().anyMatch(k -> k.startsWith(mathFunctionPath));
    }

    public boolean skip(Context<T> context) {
        Deque<WebTemplateNode> nodes = context.getNodeDeque();
        WebTemplateNode node = nodes.poll();
        WebTemplateNode parent = nodes.peek();
        nodes.push(node);
        return this.skip(node, parent);
    }

    public boolean skip(WebTemplateNode node, WebTemplateNode parent) {
        if (node.isArchetypeSlot()) {
            return true;
        }
        if (parent != null && this.isNonMandatoryRmAttribute(node, parent)) {
            return true;
        }
        if (parent != null && parent.getRmType().equals("ISM_TRANSITION") && !parent.getId().equals("ism_transition")) {
            return true;
        }
        if (FlatHelper.rmTypeMatches(node, "HISTORY", "ITEM_TREE", "ITEM_LIST", "ITEM_SINGLE", "ITEM_TABLE", "ITEM_STRUCTURE")) {
            return true;
        }
        if (parent != null && this.isEvent(node)) {
            return parent.getChildren().stream().collect(Collectors.groupingBy(WebTemplateNode::getAqlPath)).entrySet().stream().filter(e -> ((List)e.getValue()).stream().anyMatch(this::isEvent)).count() == 1L && node.getMax() == 1;
        }
        if (node.getRmType().equals("ELEMENT")) {
            List<String> trueChildren = node.getChildren().stream().filter(n -> !List.of("name", "null_flavour", "feeder_audit").contains(n.getName())).map(WebTemplateNode::getRmType).toList();
            return node.getChildren().stream().anyMatch(n -> n.getId().equals("value")) || trueChildren.size() == 2 && trueChildren.containsAll(List.of("DV_TEXT", "DV_CODED_TEXT"));
        }
        if (node.getRmType().equals("CODE_PHRASE") && parent != null) {
            return parent.getRmType().equals("DV_CODED_TEXT");
        }
        if (node.getRmType().equals("ISM_TRANSITION")) {
            return !node.getId().equals("ism_transition");
        }
        return false;
    }

    public boolean isEvent(WebTemplateNode node) {
        RMTypeInfo typeInfo = Walker.ARCHIE_RM_INFO_LOOKUP.getTypeInfo(node.getRmType());
        return typeInfo != null && Event.class.isAssignableFrom(typeInfo.getJavaClass());
    }

    public boolean isNonMandatoryRmAttribute(WebTemplateNode node, WebTemplateNode parent) {
        boolean nonMandatoryInWebTemplate;
        RMTypeInfo typeInfo = Walker.ARCHIE_RM_INFO_LOOKUP.getTypeInfo(parent.getRmType());
        String rmName = typeInfo.getRmName();
        String nodeName = node.getName();
        boolean mandatoryNotInWebTemplate = Set.of("name", "archetype_node_id", "origin", "media_type", "upper_included", "lower_included", "upper_unbounded", "lower_unbounded").contains(nodeName);
        if (mandatoryNotInWebTemplate) {
            return true;
        }
        boolean bl = nonMandatoryInWebTemplate = "ACTIVITY".equals(rmName) && "timing".equals(nodeName) || "INSTRUCTION".equals(rmName) && "expiry_time".equals(nodeName) || "INTERVAL_EVENT".equals(rmName) && "width".equals(nodeName) || "INTERVAL_EVENT".equals(rmName) && "math_function".equals(nodeName) || "ISM_TRANSITION".equals(rmName) && "transition".equals(nodeName);
        if (nonMandatoryInWebTemplate) {
            return false;
        }
        return node.getMin() == 0 && typeInfo.getAttributes().containsKey(nodeName);
    }

    public static void consumeAllMatching(String term, Map<FlatPathDto, String> values, Set<String> consumedPaths, boolean exact) {
        consumedPaths.addAll(values.keySet().stream().filter(s -> exact ? s.isEqualTo((CharSequence)term) : s.startsWith((CharSequence)term)).map(FlatPathDto::format).collect(Collectors.toSet()));
    }

    public static Map<Integer, Map<FlatPathDto, String>> extractMultiValued(String currentTerm, String childTerm, Map<FlatPathDto, String> values) {
        FlatPathDto currentTermDto = new FlatPathDto((CharSequence)currentTerm);
        FlatPathDto otherPath = childTerm == null ? currentTermDto : currentTermDto.pathWithChild(FlatPathParser.parse((CharSequence)childTerm));
        return values.entrySet().stream().filter(s -> ((FlatPathDto)s.getKey()).startsWith(otherPath)).collect(Collectors.groupingBy(e -> Optional.ofNullable(FlatPathDto.removeStart((FlatPathDto)((FlatPathDto)e.getKey()), (FlatPathDto)currentTermDto).getCount()).orElse(0), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static Map<FlatPathDto, String> filter(Map<FlatPathDto, String> values, String path, boolean includeRaw) {
        return values.entrySet().stream().filter(e -> ((FlatPathDto)e.getKey()).startsWith((CharSequence)path)).filter(e -> includeRaw || !"raw".equals(((FlatPathDto)e.getKey()).getLast().getAttributeName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<FlatPathDto, String> convertAttributeToFlat(Map<FlatPathDto, String> values, String path, String attr, String node) {
        FlatPathDto pathDto = FlatPathParser.parse((CharSequence)path);
        String attrPostfix = attr + "_";
        return values.entrySet().stream().collect(Collectors.toMap(e1 -> {
            String attributeName = ((FlatPathDto)e1.getKey()).getLast().getAttributeName();
            if (StringUtils.contains((CharSequence)attributeName, (CharSequence)attrPostfix)) {
                Integer count = Integer.valueOf(StringUtils.substringAfter((String)attributeName, (String)":"));
                String attribute = StringUtils.substringBetween((String)attributeName, (String)attrPostfix, (String)":");
                return pathDto.pathWithChild(new FlatPathDto(node, null, count, attribute));
            }
            return (FlatPathDto)e1.getKey();
        }, Map.Entry::getValue));
    }

    public static <E extends EnumValueSet> E findEnumValueOrThrow(String value, Class<E> clazz) {
        return (E)Arrays.stream((EnumValueSet[])clazz.getEnumConstants()).filter(e -> e.getCode().equals(value) || e.getValue().equals(value)).findAny().orElseThrow(() -> new SdkException(String.format("Unknown Value %s in terminology %s", value, ((EnumValueSet[])clazz.getEnumConstants())[0].getTerminologyId())));
    }

    public static WebTemplateNode buildDummyChild(String attributeName, WebTemplateNode parent) {
        WebTemplateNode node = new WebTemplateNode();
        node.setId(OPTParser.buildId((String)attributeName));
        node.setName(attributeName);
        node.setAqlPath(parent.getAqlPathDto().addEnd(new String[]{attributeName}));
        node.setMax(0);
        node.setMax(1);
        return node;
    }

    public static WebTemplateNode findOrBuildSubNode(Context<?> context, String id) {
        return context.getNodeDeque().peek().findChildById(id).orElse(FlatHelper.buildDummyChild(id, context.getNodeDeque().peek()));
    }
}

