/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.ItemExtractor;
import org.ehrbase.openehr.sdk.serialisation.walker.Walker;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public abstract class FromCompositionWalker<T>
extends Walker<T> {
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();

    @Override
    protected Object extractRMChild(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, BooleanSupplier isChoice, Integer count) {
        Object child = ItemExtractor.extractChild(currentRM, currentNode, childNode, count != null ? () -> false : isChoice);
        if (count != null && child instanceof List) {
            List childList = (List)child;
            Object selectedChild = childList.get(count);
            if (isChoice.getAsBoolean() && !ARCHIE_RM_INFO_LOOKUP.getTypeInfo(childNode.getRmType()).getJavaClass().isAssignableFrom(selectedChild.getClass())) {
                return null;
            }
            child = selectedChild;
        }
        return this.wrap(child);
    }

    @Override
    protected int calculateSize(Context<T> context, WebTemplateNode childNode) {
        Object child = this.extractRMChild(context.getRmObjectDeque().peek(), context.getNodeDeque().peek(), childNode, () -> false, null);
        if (child instanceof List) {
            List l = (List)child;
            return l.size();
        }
        return 0;
    }

    @Override
    protected ImmutablePair<T, RMObject> extractPair(Context<T> context, WebTemplateNode currentNode, BooleanSupplier isChoice, WebTemplateNode childNode, Integer i) {
        RMObject currentChild = (RMObject)this.extractRMChild(context.getRmObjectDeque().peek(), currentNode, childNode, isChoice, i);
        if (currentChild == null) {
            return null;
        }
        T childObject = this.extract(context, childNode, isChoice, i);
        return new ImmutablePair(childObject, (Object)currentChild);
    }
}

