/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.webtemplatepath.AqlPath;
import org.ehrbase.openehr.sdk.serialisation.walker.RMHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.RmBoolean;
import org.ehrbase.openehr.sdk.serialisation.walker.Walker;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public final class ItemExtractor {
    private ItemExtractor() {
    }

    public static Object extractChild(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, BooleanSupplier isChoice) {
        Iterator childIt;
        if (!(currentRM instanceof Pathable)) {
            if (currentRM instanceof DvInterval) {
                DvInterval dvi = (DvInterval)currentRM;
                return switch (childNode.getAqlPathDto().getLastNode().getName()) {
                    case "upper_included" -> new RmBoolean(dvi.isUpperIncluded());
                    case "lower_included" -> new RmBoolean(dvi.isLowerIncluded());
                    case "lower" -> dvi.getLower();
                    case "upper" -> dvi.getUpper();
                    default -> null;
                };
            }
            throw new SdkException(String.format("Cannot extract %s from class %s", childNode.getAqlPathDto(), currentRM.getClass().getSimpleName()));
        }
        Pathable currentPathable = (Pathable)currentRM;
        if (currentRM instanceof Event && childNode.getAqlPathDto().getLastNode().getName().equals("offset")) {
            return null;
        }
        AqlPath childPath = currentNode.buildRelativePath(childNode, false);
        Stream<Object> itemsAtPath = ItemExtractor.itemsAtPath(childPath, currentPathable);
        String baseName = childPath.getBaseNode().findOtherPredicate("name/value");
        if (StringUtils.isNotBlank((CharSequence)baseName) && Locatable.class.isAssignableFrom(Walker.ARCHIE_RM_INFO_LOOKUP.getClass(childNode.getRmType()))) {
            itemsAtPath = itemsAtPath.filter(c -> baseName.equals(((Locatable)c).getNameAsString()));
        }
        if (isChoice.getAsBoolean()) {
            itemsAtPath = itemsAtPath.filter(c -> {
                int typeLength;
                String childRmType = childNode.getRmType();
                String typeRmName = Walker.ARCHIE_RM_INFO_LOOKUP.getTypeInfo(c.getClass()).getRmName();
                int childLength = childRmType.length();
                if (childLength == (typeLength = typeRmName.length())) {
                    return childRmType.equals(typeRmName);
                }
                if (childLength < typeLength) {
                    return false;
                }
                if (childRmType.charAt(typeLength) == '<') {
                    return childRmType.startsWith(typeRmName);
                }
                return false;
            });
        }
        if (!(childIt = itemsAtPath.iterator()).hasNext()) {
            return null;
        }
        if (RMHelper.isMulti(currentNode, childNode)) {
            return IteratorUtils.toList(childIt);
        }
        Object child = childIt.next();
        if (child instanceof Element) {
            Element el = (Element)child;
            if (!childNode.getRmType().equals("ELEMENT")) {
                return el.getValue();
            }
        }
        return child;
    }

    private static Stream<?> itemsAtPath(AqlPath path, Pathable currentPathable) {
        return new AqlPathRMPathQuery(path).findList((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), currentPathable).stream().map(RMObjectWithPath::getObject);
    }

    public static final class AqlPathRMPathQuery
    extends RMPathQuery {
        public AqlPathRMPathQuery(AqlPath path) {
            super("");
            List pathSegments = this.getPathSegments();
            pathSegments.clear();
            ((ArrayList)pathSegments).ensureCapacity(path.getNodes().size());
            path.getNodes().forEach(node -> pathSegments.add(new PathSegment(node.getName(), node.getAtCode())));
        }
    }
}

