/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.FeederAuditDetails;
import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.DvURI;
import com.nedap.archie.rm.datavalues.encapsulated.DvParsable;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class RMHelper {
    private RMHelper() {
    }

    public static boolean isEmpty(Object rmObject) {
        if (rmObject == null) {
            return true;
        }
        if (rmObject instanceof Collection) {
            return ((Collection)rmObject).isEmpty() || ((Collection)rmObject).stream().allMatch(RMHelper::isEmpty);
        }
        if (rmObject instanceof Participation) {
            return ((Participation)rmObject).getPerformer() == null;
        }
        if (rmObject instanceof CodePhrase) {
            return StringUtils.isBlank((CharSequence)((CodePhrase)rmObject).getCodeString());
        }
        if (rmObject instanceof DvCodedText) {
            return RMHelper.isEmpty(((DvCodedText)rmObject).getDefiningCode());
        }
        if (rmObject instanceof DvText) {
            return ((DvText)rmObject).getValue() == null;
        }
        if (rmObject instanceof PartyIdentified) {
            return ((PartyIdentified)rmObject).getName() == null && CollectionUtils.isEmpty((Collection)((PartyIdentified)rmObject).getIdentifiers());
        }
        if (rmObject instanceof DvDateTime) {
            return ((DvDateTime)rmObject).getValue() == null;
        }
        if (rmObject instanceof DvParsable) {
            return ((DvParsable)rmObject).getValue() == null && ((DvParsable)rmObject).getFormalism() == null;
        }
        if (rmObject instanceof FeederAudit) {
            return RMHelper.isEmpty(((FeederAudit)rmObject).getOriginalContent());
        }
        if (rmObject instanceof FeederAuditDetails) {
            return StringUtils.isEmpty((CharSequence)((FeederAuditDetails)rmObject).getSystemId());
        }
        if (rmObject instanceof IsmTransition) {
            return RMHelper.isEmpty(((IsmTransition)rmObject).getCurrentState());
        }
        if (rmObject instanceof DvURI) {
            return ((DvURI)rmObject).getValue() == null;
        }
        return false;
    }

    static boolean isMulti(WebTemplateNode parent, WebTemplateNode child) {
        return parent.getRmType().equals("ELEMENT") ? child.getId().equals("link") : child.isMulti();
    }
}

