/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.openehr.sdk.serialisation.walker.Context;
import org.ehrbase.openehr.sdk.serialisation.walker.NodeId;
import org.ehrbase.openehr.sdk.serialisation.walker.RMHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.RmBoolean;
import org.ehrbase.openehr.sdk.serialisation.walker.RmLong;
import org.ehrbase.openehr.sdk.serialisation.walker.RmString;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public abstract class Walker<T> {
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();

    public void walk(Composition composition, T object, WebTemplate webTemplate, DefaultValues defaultValues, String templateId) {
        this.walk((RMObject)composition, object, webTemplate.getTree(), defaultValues, templateId);
    }

    public void walk(RMObject composition, T object, WebTemplateNode root, String templateId) {
        this.walk(composition, object, root, null, templateId);
    }

    public void walk(RMObject composition, T object, WebTemplateNode root, DefaultValues defaultValues, String templateId) {
        Context context = new Context();
        context.getNodeDeque().push(new WebTemplateNode(root));
        context.getObjectDeque().push(object);
        context.getRmObjectDeque().push(composition);
        context.setTemplateId(templateId);
        if (defaultValues != null) {
            context.setDefaultValues(defaultValues);
        } else {
            context.setDefaultValues(new DefaultValues());
        }
        this.handle(context);
    }

    private void handle(Context<T> context) {
        this.preHandle(context);
        WebTemplateNode currentNode = context.getNodeDeque().peek();
        if (this.visitChildren(currentNode)) {
            if ("ACTION".equals(currentNode.getRmType())) {
                Iterator it = currentNode.getChildren().iterator();
                while (it.hasNext() && !"ISM_TRANSITION".equals(((WebTemplateNode)it.next()).getRmType())) {
                }
                while (it.hasNext()) {
                    if (!"ISM_TRANSITION".equals(((WebTemplateNode)it.next()).getRmType())) continue;
                    it.remove();
                }
            }
            this.handleInheritance(currentNode);
            Map childrenByPath = currentNode.getChildren().stream().collect(Collectors.groupingBy(WebTemplateNode::getAqlPathDto, LinkedHashMap::new, Collectors.toList()));
            Predicate<WebTemplateNode> choicePredicate = n -> ((List)childrenByPath.get(n.getAqlPathDto())).size() > 1;
            for (List childrenForPath : childrenByPath.values()) {
                Stream<NodeConstellation> childConstellations;
                boolean anyMulti = Walker.isMulti(currentNode, childrenForPath);
                if (!anyMulti) {
                    childConstellations = this.streamChildConstellations(context, currentNode, choicePredicate, childrenForPath, null);
                } else {
                    int size = this.calculateSize(context, (WebTemplateNode)childrenForPath.get(0));
                    childConstellations = IntStream.range(0, size).boxed().flatMap(index -> this.streamChildConstellations(context, currentNode, choicePredicate, childrenForPath, (Integer)index).limit(1L));
                }
                childConstellations.forEach(constellation -> {
                    WebTemplateNode childNode = constellation.getNode();
                    context.getNodeDeque().push(childNode);
                    context.getObjectDeque().push(constellation.getObject());
                    context.getRmObjectDeque().push(constellation.getRmObject());
                    if (constellation.getIndex() != null) {
                        context.getCountMap().put(new NodeId(childNode), constellation.getIndex());
                    }
                    this.handle(context);
                });
            }
            this.postVisitChildren(context, currentNode);
        }
        this.postHandle(context);
        this.insertDefaults(context);
        context.getRmObjectDeque().remove();
        context.getNodeDeque().remove();
        context.getObjectDeque().remove();
    }

    private static boolean isMulti(WebTemplateNode currentNode, List<WebTemplateNode> childrenForPath) {
        for (WebTemplateNode n : childrenForPath) {
            if (!RMHelper.isMulti(currentNode, n)) continue;
            return true;
        }
        return false;
    }

    protected void postVisitChildren(Context<T> context, WebTemplateNode currentNode) {
    }

    private Stream<NodeConstellation> streamChildConstellations(Context<T> context, WebTemplateNode currentNode, Predicate<WebTemplateNode> choicePredicate, List<WebTemplateNode> childrenForPath, Integer index) {
        return childrenForPath.stream().map(childNode -> {
            ImmutablePair<T, RMObject> pair = this.extractPair(context, currentNode, () -> choicePredicate.test((WebTemplateNode)childNode), (WebTemplateNode)childNode, index);
            if (pair == null || ObjectUtils.anyNull((Object[])new Object[]{pair.getLeft(), pair.getRight()})) {
                return null;
            }
            return new NodeConstellation(index, pair.getLeft(), (RMObject)pair.getRight(), (WebTemplateNode)childNode);
        }).filter(Objects::nonNull);
    }

    protected void handleInheritance(WebTemplateNode currentNode) {
        ArrayList<WebTemplateNode> nodesToAdd = new ArrayList<WebTemplateNode>();
        Iterator it = currentNode.getChildren().iterator();
        while (it.hasNext()) {
            WebTemplateNode childNode = (WebTemplateNode)it.next();
            switch (childNode.getRmType()) {
                case "DV_TEXT": {
                    if (!Walker.siblingMissing(currentNode, childNode, "DV_CODED_TEXT")) break;
                    nodesToAdd.add(Walker.buildCopy(childNode, "DV_CODED_TEXT"));
                    break;
                }
                case "PARTY_PROXY": {
                    nodesToAdd.add(Walker.buildCopy(childNode, "PARTY_SELF"));
                    nodesToAdd.add(Walker.buildCopy(childNode, "PARTY_IDENTIFIED"));
                    nodesToAdd.add(Walker.copyAsPartyRelated(childNode));
                    it.remove();
                    break;
                }
                case "PARTY_IDENTIFIED": {
                    if (!Walker.siblingMissing(currentNode, childNode, "PARTY_RELATED")) break;
                    nodesToAdd.add(Walker.copyAsPartyRelated(childNode));
                    break;
                }
                case "EVENT": {
                    WebTemplateNode intervalEvent = Walker.buildCopy(childNode, "INTERVAL_EVENT");
                    WebTemplateNode width = new WebTemplateNode();
                    width.setId("width");
                    width.setName("width");
                    width.setRmType("DV_DURATION");
                    width.setMax(1);
                    width.setMin(1);
                    width.setAqlPath(intervalEvent.getAqlPathDto().addEnd(new String[]{"width"}));
                    intervalEvent.getChildren().add(width);
                    WebTemplateNode math = new WebTemplateNode();
                    math.setId("math_function");
                    math.setName("math_function");
                    math.setRmType("DV_CODED_TEXT");
                    math.setMax(1);
                    math.setMin(1);
                    math.setAqlPath(intervalEvent.getAqlPathDto().addEnd(new String[]{"math_function"}));
                    intervalEvent.getChildren().add(math);
                    WebTemplateNode sampleCount = new WebTemplateNode();
                    sampleCount.setId("sample_count");
                    sampleCount.setName("sample_count");
                    sampleCount.setRmType("LONG");
                    sampleCount.setMax(1);
                    sampleCount.setAqlPath(intervalEvent.getAqlPathDto().addEnd(new String[]{"sample_count"}));
                    intervalEvent.getChildren().add(sampleCount);
                    nodesToAdd.add(intervalEvent);
                    nodesToAdd.add(Walker.buildCopy(childNode, "POINT_EVENT"));
                    it.remove();
                    break;
                }
            }
        }
        if (!nodesToAdd.isEmpty()) {
            currentNode.getChildren().addAll(nodesToAdd);
        }
    }

    private static boolean siblingMissing(WebTemplateNode parentNode, WebTemplateNode childNode, String rmType) {
        List children = parentNode.getChildren();
        if (children.size() <= 1) {
            return true;
        }
        for (WebTemplateNode child : children) {
            if (!rmType.equals(child.getRmType()) || child == childNode || !child.getAqlPathDto().equals((Object)childNode.getAqlPathDto())) continue;
            return false;
        }
        return true;
    }

    private static WebTemplateNode copyAsPartyRelated(WebTemplateNode party) {
        WebTemplateNode node = Walker.buildCopy(party, "PARTY_RELATED");
        WebTemplateNode relationship = new WebTemplateNode();
        relationship.setId("relationship");
        relationship.setName("relationship");
        relationship.setRmType("DV_CODED_TEXT");
        relationship.setMax(1);
        relationship.setMin(1);
        relationship.setAqlPath(node.getAqlPathDto().addEnd(new String[]{"relationship"}));
        node.getChildren().add(relationship);
        return node;
    }

    private static WebTemplateNode buildCopy(WebTemplateNode childNode, String rmType) {
        WebTemplateNode partyIdent = new WebTemplateNode(childNode);
        partyIdent.setRmType(rmType);
        return partyIdent;
    }

    protected abstract ImmutablePair<T, RMObject> extractPair(Context<T> var1, WebTemplateNode var2, BooleanSupplier var3, WebTemplateNode var4, Integer var5);

    protected abstract Object extractRMChild(RMObject var1, WebTemplateNode var2, WebTemplateNode var3, BooleanSupplier var4, Integer var5);

    protected boolean visitChildren(WebTemplateNode node) {
        RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(node.getRmType());
        if (typeInfo == null) {
            return false;
        }
        Class javaType = typeInfo.getJavaClass();
        return Pathable.class.isAssignableFrom(javaType) || DvInterval.class.isAssignableFrom(javaType);
    }

    protected abstract T extract(Context<T> var1, WebTemplateNode var2, BooleanSupplier var3, Integer var4);

    protected abstract void preHandle(Context<T> var1);

    protected abstract void postHandle(Context<T> var1);

    protected void insertDefaults(Context<T> context) {
    }

    protected Object wrap(Object child) {
        if (child == null) {
            return null;
        }
        if (child instanceof String) {
            String strVal = (String)child;
            return new RmString(strVal);
        }
        if (child instanceof Long) {
            Long longVal = (Long)child;
            return new RmLong(longVal);
        }
        if (child instanceof Boolean) {
            Boolean boolVal = (Boolean)child;
            return new RmBoolean(boolVal);
        }
        return child;
    }

    protected abstract int calculateSize(Context<T> var1, WebTemplateNode var2);

    protected RMObject deepClone(RMObject rmObject) {
        if (rmObject == null) {
            return null;
        }
        CanonicalJson canonicalXML = new CanonicalJson();
        return canonicalXML.unmarshal(canonicalXML.marshal(rmObject), rmObject.getClass());
    }

    private final class NodeConstellation {
        private final Integer index;
        private final T object;
        private final RMObject rmObject;
        private final WebTemplateNode node;

        private NodeConstellation(Integer index, T object, RMObject rmObject, WebTemplateNode node) {
            this.index = index;
            this.object = object;
            this.rmObject = rmObject;
            this.node = node;
        }

        public Integer getIndex() {
            return this.index;
        }

        public T getObject() {
            return this.object;
        }

        public RMObject getRmObject() {
            return this.rmObject;
        }

        public WebTemplateNode getNode() {
            return this.node;
        }
    }

    public static class EventHelper {
        private WebTemplateNode event;
        private WebTemplateNode pointEvent;
        private WebTemplateNode intervalEvent;

        public EventHelper(WebTemplateNode event) {
            this.event = event;
        }

        public WebTemplateNode getPointEvent() {
            return this.pointEvent;
        }

        public WebTemplateNode getIntervalEvent() {
            return this.intervalEvent;
        }

        public EventHelper invoke() {
            this.pointEvent = new WebTemplateNode(this.event);
            this.intervalEvent = new WebTemplateNode(this.event);
            this.pointEvent.setRmType("POINT_EVENT");
            this.intervalEvent.setRmType("INTERVAL_EVENT");
            WebTemplateNode width = new WebTemplateNode();
            width.setId("width");
            width.setName("width");
            width.setRmType("DV_DURATION");
            width.setMax(1);
            width.setMin(1);
            width.setAqlPath(this.event.getAqlPathDto().addEnd(new String[]{"width"}));
            this.intervalEvent.getChildren().add(width);
            WebTemplateNode math = new WebTemplateNode();
            math.setId("math_function");
            math.setName("math_function");
            math.setRmType("DV_CODED_TEXT");
            math.setMax(1);
            math.setMin(1);
            math.setAqlPath(this.event.getAqlPathDto().addEnd(new String[]{"math_function"}));
            this.intervalEvent.getChildren().add(math);
            WebTemplateNode sampleCount = new WebTemplateNode();
            sampleCount.setId("sample_count");
            sampleCount.setName("sample_count");
            sampleCount.setRmType("LONG");
            sampleCount.setMax(1);
            sampleCount.setAqlPath(this.event.getAqlPathDto().addEnd(new String[]{"sample_count"}));
            this.intervalEvent.getChildren().add(sampleCount);
            return this;
        }
    }
}

