/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvEHRURI;
import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.generator.commons.interfaces.EnumValueSet;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.ParticipationMode;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.Setting;
import org.ehrbase.openehr.sdk.generator.commons.shareddefinition.State;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.ArchieObjectMapperProvider;
import org.ehrbase.openehr.sdk.serialisation.walker.FlatHelper;
import org.ehrbase.openehr.sdk.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.path.flat.FlatPathDto;

public class DefaultValues {
    public static final String COMPACT = "compact";
    private final Map<DefaultValuePath, Object> defaultValueMap = new HashMap<DefaultValuePath, Object>();
    private static final ObjectMapper OBJECT_MAPPER = ArchieObjectMapperProvider.getObjectMapper();

    public DefaultValues() {
    }

    public DefaultValues(Map<String, String> flat) {
        Stream.of(DefaultValuePath.LANGUAGE, DefaultValuePath.TERRITORY, DefaultValuePath.COMPOSER_NAME, DefaultValuePath.COMPOSER_ID, DefaultValuePath.ID_SCHEME, DefaultValuePath.ID_NAMESPACE, DefaultValuePath.COMPOSER_SELF, DefaultValuePath.TIME, DefaultValuePath.END_TIME, DefaultValuePath.HISTORY_ORIGIN, DefaultValuePath.ACTION_TIME, DefaultValuePath.ACTIVITY_TIMING, DefaultValuePath.PROVIDER_ID, DefaultValuePath.PROVIDER_NAME, DefaultValuePath.HEALTHCARE_FACILITY_NAME, DefaultValuePath.HEALTHCARE_FACILITY_ID, DefaultValuePath.ACTION_ISM_TRANSITION_CURRENT_STATE, DefaultValuePath.INSTRUCTION_NARRATIVE, DefaultValuePath.LOCATION, DefaultValuePath.SETTING, DefaultValuePath.PARTICIPATION, DefaultValuePath.WORKFLOW_ID, DefaultValuePath.LINKS).forEach(path -> {
            Map<String, String> subValues = DefaultValues.filter(flat, path.getPath());
            if (!subValues.isEmpty()) {
                if (EnumValueSet.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    this.defaultValueMap.put((DefaultValuePath)path, FlatHelper.findEnumValueOrThrow(value, path.getType()));
                } else if (String.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    this.defaultValueMap.put((DefaultValuePath)path, value);
                } else if (Boolean.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    if (value.equals("true")) {
                        this.defaultValueMap.put((DefaultValuePath)path, true);
                    }
                } else if (TemporalAccessor.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    if ("now".equals(value)) {
                        this.defaultValueMap.put((DefaultValuePath)path, OffsetDateTime.now());
                    } else {
                        this.defaultValueMap.put((DefaultValuePath)path, DateTimeParsers.parseDateTimeValue((String)value));
                    }
                } else if (path.equals(DefaultValuePath.PARTICIPATION)) {
                    Map<Integer, Map<FlatPathDto, String>> participationValues = FlatHelper.extractMultiValued("ctx", null, subValues.entrySet().stream().collect(Collectors.toMap(e -> new FlatPathDto((CharSequence)e.getKey()), Map.Entry::getValue)));
                    participationValues.replaceAll((k, v) -> {
                        Map<FlatPathDto, String> map = v.entrySet().stream().collect(Collectors.toMap(e1 -> {
                            if (StringUtils.equals((CharSequence)((FlatPathDto)e1.getKey()).getLast().getName(), (CharSequence)"participation_identifiers")) {
                                Integer integer = Optional.ofNullable(((FlatPathDto)e1.getKey()).getLast().getAttributeName()).map(a -> StringUtils.substringAfter((String)a, (int)58)).map(Integer::valueOf).orElse(0);
                                return new FlatPathDto((CharSequence)("ctx/" + DefaultValuePath.PARTICIPATION.getPath() + ":" + k + "/_identifier:" + integer + "|" + Optional.ofNullable(StringUtils.substringBefore((String)((FlatPathDto)e1.getKey()).getLast().getAttributeName(), (String)":")).orElse(COMPACT)));
                            }
                            return new FlatPathDto((CharSequence)("ctx/" + DefaultValuePath.PARTICIPATION.getPath() + ":" + k + "|" + StringUtils.substringAfter((String)((FlatPathDto)e1.getKey()).getLast().getName(), (String)"_")));
                        }, Map.Entry::getValue));
                        return map;
                    });
                    this.defaultValueMap.put((DefaultValuePath)path, participationValues.entrySet().stream().map(e -> DefaultValues.buildParticipation((Map)e.getValue(), "ctx/" + DefaultValuePath.PARTICIPATION.getPath() + ":" + String.valueOf(e.getKey()))).collect(Collectors.toList()));
                } else if (path.equals(DefaultValuePath.WORKFLOW_ID)) {
                    ObjectRef ref = new ObjectRef();
                    Map<String, String> attributes = subValues.entrySet().stream().collect(Collectors.toMap(e1 -> StringUtils.substringBefore((String)StringUtils.substringAfter((String)((String)e1.getKey()), (String)"|"), (String)":"), stringStringEntry -> StringUtils.unwrap((String)((String)stringStringEntry.getValue()), (char)'\"')));
                    ref.setNamespace(attributes.get("namespace"));
                    ref.setType(attributes.get("type"));
                    ref.setId((ObjectId)new GenericId());
                    ((GenericId)ref.getId()).setValue(attributes.get("id"));
                    ((GenericId)ref.getId()).setScheme(attributes.get("id_scheme"));
                    this.defaultValueMap.put((DefaultValuePath)path, ref);
                } else if (path.equals(DefaultValuePath.LINKS)) {
                    Map<Integer, Map<FlatPathDto, String>> linkValues = FlatHelper.extractMultiValued("ctx", null, subValues.entrySet().stream().collect(Collectors.toMap(e -> new FlatPathDto((CharSequence)e.getKey()), Map.Entry::getValue)));
                    this.defaultValueMap.put((DefaultValuePath)path, linkValues.entrySet().stream().map(e -> DefaultValues.createLink((Map)e.getValue(), "ctx/" + DefaultValuePath.LINKS.getPath() + ":" + String.valueOf(e.getKey()))).collect(Collectors.toList()));
                }
            }
            this.setFlatDefaults();
        });
    }

    private void setFlatDefaults() {
        if (this.defaultValueMap.containsKey(DefaultValuePath.PARTICIPATION)) {
            this.getDefaultValue(DefaultValuePath.PARTICIPATION).stream().map(Participation::getPerformer).map(PartyProxy::getExternalRef).filter(Objects::nonNull).filter(ref -> ref.getId() != null).forEach(ref -> {
                ref.setNamespace(this.getDefaultValue(DefaultValuePath.ID_NAMESPACE));
                ((GenericId)ref.getId()).setScheme(this.getDefaultValue(DefaultValuePath.ID_SCHEME));
            });
        }
        if (this.defaultValueMap.containsKey(DefaultValuePath.WORKFLOW_ID)) {
            if (((GenericId)this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).getId()).getScheme() == null) {
                ((GenericId)this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).getId()).setScheme(this.getDefaultValue(DefaultValuePath.ID_SCHEME));
            }
            if (this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).getNamespace() == null) {
                this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).setNamespace(this.getDefaultValue(DefaultValuePath.ID_NAMESPACE));
            }
        }
        this.defaultValueMap.putIfAbsent(DefaultValuePath.TIME, OffsetDateTime.now());
        this.defaultValueMap.putIfAbsent(DefaultValuePath.ACTION_ISM_TRANSITION_CURRENT_STATE, State.COMPLETED);
        this.defaultValueMap.putIfAbsent(DefaultValuePath.SETTING, Setting.OTHER_CARE);
        this.defaultValueMap.putIfAbsent(DefaultValuePath.ACTIVITY_TIMING, "R1");
        this.defaultValueMap.putIfAbsent(DefaultValuePath.INSTRUCTION_NARRATIVE, "<none>");
    }

    public static Link createLink(Map<FlatPathDto, String> valueMap, String path) {
        Link link = new Link();
        DefaultValues.setValue(path, "meaning", valueMap, s -> {
            if (s != null) {
                link.setMeaning(new DvText(s));
            }
        }, String.class);
        DefaultValues.setValue(path, "type", valueMap, s -> {
            if (s != null) {
                link.setType(new DvText(s));
            }
        }, String.class);
        DefaultValues.setValue(path, "target", valueMap, s -> {
            if (s != null) {
                link.setTarget(new DvEHRURI(s));
            }
        }, String.class);
        return link;
    }

    private static Map<String, String> filter(Map<String, String> flat, String path) {
        return flat.entrySet().stream().filter(e -> StringUtils.startsWith((CharSequence)((CharSequence)e.getKey()), (CharSequence)("ctx/" + path))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Participation buildParticipation(Map<FlatPathDto, String> subValues, String path) {
        Participation participation = new Participation();
        if (FlatHelper.isExactlyPartyIdentified(subValues, path, null)) {
            participation.setPerformer((PartyProxy)new PartyIdentified());
        } else if (FlatHelper.isExactlyPartyRelated(subValues, path, null)) {
            participation.setPerformer((PartyProxy)new PartyRelated());
        } else {
            participation.setPerformer((PartyProxy)new PartySelf());
        }
        DefaultValues.setValue(path, "id", subValues, s -> {
            if (s != null) {
                participation.getPerformer().setExternalRef(new PartyRef());
                participation.getPerformer().getExternalRef().setType("PARTY");
                GenericId id = new GenericId();
                id.setValue(s);
                participation.getPerformer().getExternalRef().setId((ObjectId)id);
            }
        }, String.class);
        DefaultValues.setValue(path, "name", subValues, s -> {
            if (s != null) {
                ((PartyIdentified)participation.getPerformer()).setName(s);
            }
        }, String.class);
        if (participation.getPerformer().getExternalRef() != null) {
            DefaultValues.setValue(path, "id_namespace", subValues, s -> {
                if (s != null) {
                    participation.getPerformer().getExternalRef().setNamespace(s);
                }
            }, String.class);
            DefaultValues.setValue(path, "id_scheme", subValues, s -> {
                if (s != null) {
                    ((GenericId)participation.getPerformer().getExternalRef().getId()).setScheme(s);
                }
            }, String.class);
        }
        DefaultValues.setValue(path, "function", subValues, s -> {
            if (s != null) {
                participation.setFunction(new DvText(s));
            }
        }, String.class);
        DefaultValues.setValue(path, "mode", subValues, s -> {
            if (s != null) {
                ParticipationMode participationMode = FlatHelper.findEnumValueOrThrow(s, ParticipationMode.class);
                participation.setMode(new DvCodedText());
                participation.getMode().setValue(participationMode.getValue());
                participation.getMode().setDefiningCode(participationMode.toCodePhrase());
            }
        }, String.class);
        Map<Integer, Map<FlatPathDto, String>> identifiers = FlatHelper.extractMultiValued(path, "/_identifier", subValues);
        if (participation.getPerformer() instanceof PartyIdentified) {
            if (identifiers.size() == 1 && identifiers.get(0).size() == 1 && COMPACT.equals(((FlatPathDto)((Map.Entry)identifiers.get(0).entrySet().stream().findAny().orElseThrow()).getKey()).getLast().getAttributeName())) {
                String ids = StringUtils.unwrap((String)((String)((Map.Entry)identifiers.get(0).entrySet().stream().findAny().orElseThrow()).getValue()), (char)'\"');
                for (String sub : ids.split(";")) {
                    DvIdentifier dvIdentifier = new DvIdentifier();
                    String[] split = sub.split("::");
                    dvIdentifier.setIssuer(split[0]);
                    dvIdentifier.setAssigner(split[1]);
                    dvIdentifier.setId(split[2]);
                    dvIdentifier.setType(split[3]);
                    ((PartyIdentified)participation.getPerformer()).addIdentifier(dvIdentifier);
                }
            } else {
                ((PartyIdentified)participation.getPerformer()).setIdentifiers(identifiers.entrySet().stream().map(e -> DefaultValues.toDvIdentifier((Map)e.getValue(), path + "/_identifier:" + String.valueOf(e.getKey()))).collect(Collectors.toList()));
            }
        }
        if (participation.getPerformer() instanceof PartyRelated) {
            DvCodedText relationship = new DvCodedText();
            relationship.setDefiningCode(new CodePhrase());
            ((PartyRelated)participation.getPerformer()).setRelationship(relationship);
            DefaultValues.setValue(path + "/relationship", "value", subValues, arg_0 -> ((DvCodedText)relationship).setValue(arg_0), String.class);
            DefaultValues.setValue(path + "/relationship", "code", subValues, arg_0 -> ((CodePhrase)relationship.getDefiningCode()).setCodeString(arg_0), String.class);
            DefaultValues.setValue(path + "/relationship", "terminology", subValues, s -> {
                if (s != null) {
                    relationship.getDefiningCode().setTerminologyId(new TerminologyId(s));
                }
            }, String.class);
        }
        return participation;
    }

    public static DvIdentifier toDvIdentifier(Map<FlatPathDto, String> valueMap, String path) {
        DvIdentifier dvIdentifier = new DvIdentifier();
        DefaultValues.setValue(path, "id", valueMap, arg_0 -> ((DvIdentifier)dvIdentifier).setId(arg_0), String.class);
        if (StringUtils.isBlank((CharSequence)dvIdentifier.getId())) {
            DefaultValues.setValue(path, null, valueMap, arg_0 -> ((DvIdentifier)dvIdentifier).setId(arg_0), String.class);
        }
        DefaultValues.setValue(path, "assigner", valueMap, arg_0 -> ((DvIdentifier)dvIdentifier).setAssigner(arg_0), String.class);
        DefaultValues.setValue(path, "issuer", valueMap, arg_0 -> ((DvIdentifier)dvIdentifier).setIssuer(arg_0), String.class);
        DefaultValues.setValue(path, "type", valueMap, arg_0 -> ((DvIdentifier)dvIdentifier).setType(arg_0), String.class);
        return dvIdentifier;
    }

    private static <S> void setValue(String term, String propertyName, Map<FlatPathDto, String> values, Consumer<S> consumer, Class<S> clazz) {
        Object key = propertyName != null ? term + "|" + propertyName : term;
        Map.Entry entry = FlatPathDto.get(values, (String)key);
        String jasonValue = (String)entry.getValue();
        if (StringUtils.isNotBlank((CharSequence)jasonValue)) {
            try {
                Object value = OBJECT_MAPPER.readValue(jasonValue, clazz);
                consumer.accept(value);
            }
            catch (JsonProcessingException e) {
                throw new SdkException(e.getMessage());
            }
        } else {
            consumer.accept(null);
        }
    }

    private static String read(String s) {
        try {
            return (String)OBJECT_MAPPER.readValue(s, String.class);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new SdkException(jsonProcessingException.getMessage());
        }
    }

    public <T> void addDefaultValue(DefaultValuePath<T> path, T value) {
        if (value == null) {
            this.defaultValueMap.remove(path);
        } else if (path.getType().isAssignableFrom(value.getClass())) {
            this.defaultValueMap.put(path, value);
        } else {
            throw new SdkException(String.format("Can not set %s can not cast %s to %s", path, path.getType().getSimpleName(), value.getClass().getSimpleName()));
        }
    }

    public void removeDefaultValue(DefaultValuePath path) {
        this.defaultValueMap.remove(path);
    }

    public <T> T getDefaultValue(DefaultValuePath<T> path) {
        return (T)this.defaultValueMap.get(path);
    }

    public boolean containsDefaultValue(DefaultValuePath<?> path) {
        return this.defaultValueMap.containsKey(path);
    }
}

