/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.interpreter;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.webtemplate.interpreter.InterpreterPathNode;

public class InterpreterPath
implements Serializable {
    private List<InterpreterPathNode> nodeList;

    public List<InterpreterPathNode> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List<InterpreterPathNode> nodeList) {
        this.nodeList = nodeList;
    }

    public AqlPath buildNormalisedAqlDto() {
        if (CollectionUtils.isNotEmpty(this.nodeList)) {
            AqlPath.AqlNode[] nodes = (AqlPath.AqlNode[])this.nodeList.stream().map(n -> n.getNormalisedNode()).toArray(AqlPath.AqlNode[]::new);
            return AqlPath.ROOT_PATH.addEnd(nodes);
        }
        return AqlPath.EMPTY_PATH;
    }

    @Deprecated
    public String buildNormalisedAql() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeList != null) {
            this.nodeList.forEach(n -> {
                sb.append("/");
                n.getNormalisedNode().appendFormat(sb, AqlPath.OtherPredicatesFormat.SHORTED);
            });
        }
        return sb.toString();
    }

    public Long extractDepth() {
        return this.nodeList.stream().filter(n -> n.getTemplateNode().isMulti()).count();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterpreterPath that = (InterpreterPath)o;
        return Objects.equals(this.nodeList, that.nodeList);
    }

    public int hashCode() {
        return Objects.hash(this.nodeList);
    }

    public String toString() {
        return "InterpreterPath{nodeList=" + this.nodeList + "}";
    }
}

