/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.interpreter;

import java.io.Serializable;
import java.util.Objects;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class SimpleTemplateNode
implements Serializable {
    private String name;
    private String nodeId;
    private String type;
    private boolean isMulti;

    public SimpleTemplateNode() {
    }

    public SimpleTemplateNode(WebTemplateNode webTemplateNode) {
        this.name = webTemplateNode.getName();
        this.nodeId = webTemplateNode.getNodeId();
        this.type = webTemplateNode.getRmType();
        this.isMulti = webTemplateNode.isMulti();
    }

    public SimpleTemplateNode(WebTemplateInput input) {
        this.name = input.getSuffix();
        this.nodeId = input.getSuffix();
        this.type = input.getType();
        this.isMulti = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public void setMulti(boolean multi) {
        this.isMulti = multi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTemplateNode that = (SimpleTemplateNode)o;
        return this.isMulti == that.isMulti && Objects.equals(this.name, that.name) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nodeId, this.type, this.isMulti);
    }

    public String toString() {
        return "SimpleTemplateNode{name='" + this.name + "', nodeId='" + this.nodeId + "', type='" + this.type + "', isMulti=" + this.isMulti + "}";
    }
}

